/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import java.util.Collection;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsBasicProverEnvironment;
import org.sosy_lab.java_smt.delegate.statistics.TimerPool;

class StatisticsInterpolatingProverEnvironment<T>
extends StatisticsBasicProverEnvironment<T>
implements InterpolatingProverEnvironment<T> {
    private final InterpolatingProverEnvironment<T> delegate;
    private final TimerPool.TimerWrapper itpTimer;

    StatisticsInterpolatingProverEnvironment(InterpolatingProverEnvironment<T> pDelegate, SolverStatistics pStats) {
        super(pDelegate, pStats);
        this.delegate = pDelegate;
        this.itpTimer = this.stats.interpolation.getNewTimer();
    }

    @Override
    public BooleanFormula getInterpolant(Collection<T> pFormulasOfA) throws SolverException, InterruptedException {
        this.itpTimer.start();
        try {
            BooleanFormula booleanFormula = this.delegate.getInterpolant(pFormulasOfA);
            return booleanFormula;
        }
        finally {
            this.itpTimer.stop();
        }
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<T>> pPartitionedFormulas) throws SolverException, InterruptedException {
        this.itpTimer.start();
        try {
            List<BooleanFormula> list = this.delegate.getSeqInterpolants(pPartitionedFormulas);
            return list;
        }
        finally {
            this.itpTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<T>> pPartitionedFormulas, int[] pStartOfSubTree) throws SolverException, InterruptedException {
        this.itpTimer.start();
        try {
            List<BooleanFormula> list = this.delegate.getTreeInterpolants(pPartitionedFormulas, pStartOfSubTree);
            return list;
        }
        finally {
            this.itpTimer.stop();
        }
    }
}

