/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.EnumerationFormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;

public class StatisticsEnumerationFormulaManager
implements EnumerationFormulaManager {
    private final EnumerationFormulaManager delegate;
    private final SolverStatistics stats;

    StatisticsEnumerationFormulaManager(EnumerationFormulaManager pDelegate, SolverStatistics pStats) {
        this.delegate = (EnumerationFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
    }

    @Override
    public FormulaType.EnumerationFormulaType declareEnumeration(String name, Set<String> elementNames) {
        this.stats.enumerationDeclarations.getAndIncrement();
        return this.delegate.declareEnumeration(name, elementNames);
    }

    @Override
    public EnumerationFormula makeConstant(String pName, FormulaType.EnumerationFormulaType pType) {
        this.stats.enumerationOperations.getAndIncrement();
        return this.delegate.makeConstant(pName, pType);
    }

    @Override
    public EnumerationFormula makeVariable(String pVar, FormulaType.EnumerationFormulaType pType) {
        this.stats.enumerationOperations.getAndIncrement();
        return this.delegate.makeVariable(pVar, pType);
    }

    @Override
    public BooleanFormula equivalence(EnumerationFormula pEnumeration1, EnumerationFormula pEnumeration2) {
        this.stats.enumerationOperations.getAndIncrement();
        return this.delegate.equivalence(pEnumeration1, pEnumeration2);
    }
}

