/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.api.StringFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingStringFormulaManager
implements StringFormulaManager {
    private final StringFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingStringFormulaManager(StringFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (StringFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public StringFormula makeString(String value) {
        this.debugging.assertThreadLocal();
        StringFormula result = this.delegate.makeString(value);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public StringFormula makeVariable(String pVar) {
        this.debugging.assertThreadLocal();
        StringFormula result = this.delegate.makeVariable(pVar);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula equal(StringFormula str1, StringFormula str2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str1);
        this.debugging.assertFormulaInContext(str2);
        BooleanFormula result = this.delegate.equal(str1, str2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterThan(StringFormula str1, StringFormula str2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str1);
        this.debugging.assertFormulaInContext(str2);
        BooleanFormula result = this.delegate.greaterThan(str1, str2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterOrEquals(StringFormula str1, StringFormula str2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str1);
        this.debugging.assertFormulaInContext(str2);
        BooleanFormula result = this.delegate.equal(str1, str2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessThan(StringFormula str1, StringFormula str2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str1);
        this.debugging.assertFormulaInContext(str2);
        BooleanFormula result = this.delegate.lessThan(str1, str2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessOrEquals(StringFormula str1, StringFormula str2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str1);
        this.debugging.assertFormulaInContext(str2);
        BooleanFormula result = this.delegate.lessOrEquals(str1, str2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula prefix(StringFormula prefix, StringFormula str) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(prefix);
        this.debugging.assertFormulaInContext(str);
        BooleanFormula result = this.delegate.prefix(prefix, str);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula suffix(StringFormula suffix, StringFormula str) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(suffix);
        this.debugging.assertFormulaInContext(str);
        BooleanFormula result = this.delegate.suffix(suffix, str);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula contains(StringFormula str, StringFormula part) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str);
        this.debugging.assertFormulaInContext(part);
        BooleanFormula result = this.delegate.contains(str, part);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public NumeralFormula.IntegerFormula indexOf(StringFormula str, StringFormula part, NumeralFormula.IntegerFormula startIndex) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str);
        this.debugging.assertFormulaInContext(part);
        this.debugging.assertFormulaInContext(startIndex);
        NumeralFormula.IntegerFormula result = this.delegate.indexOf(str, part, startIndex);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public StringFormula charAt(StringFormula str, NumeralFormula.IntegerFormula index) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str);
        this.debugging.assertFormulaInContext(index);
        StringFormula result = this.delegate.charAt(str, index);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public StringFormula substring(StringFormula str, NumeralFormula.IntegerFormula index, NumeralFormula.IntegerFormula length) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str);
        this.debugging.assertFormulaInContext(index);
        this.debugging.assertFormulaInContext(length);
        StringFormula result = this.delegate.substring(str, index, length);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public StringFormula replace(StringFormula fullStr, StringFormula target, StringFormula replacement) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(fullStr);
        this.debugging.assertFormulaInContext(target);
        this.debugging.assertFormulaInContext(replacement);
        StringFormula result = this.delegate.replace(fullStr, target, replacement);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public StringFormula replaceAll(StringFormula fullStr, StringFormula target, StringFormula replacement) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(fullStr);
        this.debugging.assertFormulaInContext(target);
        this.debugging.assertFormulaInContext(replacement);
        StringFormula result = this.delegate.replaceAll(fullStr, target, replacement);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public NumeralFormula.IntegerFormula length(StringFormula str) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str);
        NumeralFormula.IntegerFormula result = this.delegate.length(str);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public StringFormula concat(List<StringFormula> parts) {
        this.debugging.assertThreadLocal();
        for (StringFormula t : parts) {
            this.debugging.assertFormulaInContext(t);
        }
        StringFormula result = this.delegate.concat(parts);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula in(StringFormula str, RegexFormula regex) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str);
        this.debugging.assertFormulaInContext(regex);
        BooleanFormula result = this.delegate.in(str, regex);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula makeRegex(String value) {
        this.debugging.assertThreadLocal();
        RegexFormula result = this.delegate.makeRegex(value);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula none() {
        this.debugging.assertThreadLocal();
        RegexFormula result = this.delegate.none();
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula all() {
        this.debugging.assertThreadLocal();
        RegexFormula result = this.delegate.all();
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula allChar() {
        this.debugging.assertThreadLocal();
        RegexFormula result = this.delegate.allChar();
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula range(StringFormula start, StringFormula end) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(start);
        this.debugging.assertFormulaInContext(end);
        RegexFormula result = this.delegate.range(start, end);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula concatRegex(List<RegexFormula> parts) {
        this.debugging.assertThreadLocal();
        for (RegexFormula t : parts) {
            this.debugging.assertFormulaInContext(t);
        }
        RegexFormula result = this.delegate.concatRegex(parts);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula union(RegexFormula regex1, RegexFormula regex2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex1);
        this.debugging.assertFormulaInContext(regex2);
        RegexFormula result = this.delegate.union(regex1, regex2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula intersection(RegexFormula regex1, RegexFormula regex2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex1);
        this.debugging.assertFormulaInContext(regex2);
        RegexFormula result = this.delegate.intersection(regex1, regex2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula complement(RegexFormula regex) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex);
        RegexFormula result = this.delegate.complement(regex);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula closure(RegexFormula regex) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex);
        RegexFormula result = this.delegate.closure(regex);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula difference(RegexFormula regex1, RegexFormula regex2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex1);
        this.debugging.assertFormulaInContext(regex2);
        RegexFormula result = this.delegate.difference(regex1, regex2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula cross(RegexFormula regex) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex);
        RegexFormula result = this.delegate.cross(regex);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula optional(RegexFormula regex) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex);
        RegexFormula result = this.delegate.optional(regex);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public RegexFormula times(RegexFormula regex, int repetitions) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(regex);
        RegexFormula result = this.delegate.times(regex, repetitions);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public NumeralFormula.IntegerFormula toIntegerFormula(StringFormula str) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(str);
        NumeralFormula.IntegerFormula result = this.delegate.toIntegerFormula(str);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public StringFormula toStringFormula(NumeralFormula.IntegerFormula number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number);
        StringFormula result = this.delegate.toStringFormula(number);
        this.debugging.addFormulaTerm(result);
        return result;
    }
}

