/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;

public class DebuggingNumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
implements NumeralFormulaManager<ParamFormulaType, ResultFormulaType> {
    private final NumeralFormulaManager<ParamFormulaType, ResultFormulaType> delegate;
    private final DebuggingAssertions debugging;

    public DebuggingNumeralFormulaManager(NumeralFormulaManager<ParamFormulaType, ResultFormulaType> pDelegate, DebuggingAssertions pDebugging) {
        this.delegate = (NumeralFormulaManager)Preconditions.checkNotNull(pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public ResultFormulaType makeNumber(long number) {
        this.debugging.assertThreadLocal();
        ResultFormulaType result = this.delegate.makeNumber(number);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType makeNumber(BigInteger number) {
        this.debugging.assertThreadLocal();
        ResultFormulaType result = this.delegate.makeNumber(number);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType makeNumber(double number) {
        this.debugging.assertThreadLocal();
        ResultFormulaType result = this.delegate.makeNumber(number);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType makeNumber(BigDecimal number) {
        this.debugging.assertThreadLocal();
        ResultFormulaType result = this.delegate.makeNumber(number);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType makeNumber(String pI) {
        this.debugging.assertThreadLocal();
        ResultFormulaType result = this.delegate.makeNumber(pI);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType makeNumber(Rational pRational) {
        this.debugging.assertThreadLocal();
        ResultFormulaType result = this.delegate.makeNumber(pRational);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType makeVariable(String pVar) {
        this.debugging.assertThreadLocal();
        ResultFormulaType result = this.delegate.makeVariable(pVar);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public FormulaType<ResultFormulaType> getFormulaType() {
        this.debugging.assertThreadLocal();
        return this.delegate.getFormulaType();
    }

    @Override
    public ResultFormulaType negate(ParamFormulaType number) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number);
        ResultFormulaType result = this.delegate.negate(number);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType add(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        ResultFormulaType result = this.delegate.add(number1, number2);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType sum(List<ParamFormulaType> operands) {
        this.debugging.assertThreadLocal();
        for (NumeralFormula t : operands) {
            this.debugging.assertFormulaInContext(t);
        }
        ResultFormulaType result = this.delegate.sum(operands);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType subtract(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        ResultFormulaType result = this.delegate.subtract(number1, number2);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType divide(ParamFormulaType numerator, ParamFormulaType denominator) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)numerator);
        this.debugging.assertFormulaInContext((Formula)denominator);
        ResultFormulaType result = this.delegate.divide(numerator, denominator);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public ResultFormulaType multiply(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        ResultFormulaType result = this.delegate.multiply(number1, number2);
        this.debugging.addFormulaTerm((Formula)result);
        return result;
    }

    @Override
    public BooleanFormula equal(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        BooleanFormula result = this.delegate.equal(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula distinct(List<ParamFormulaType> pNumbers) {
        this.debugging.assertThreadLocal();
        for (NumeralFormula t : pNumbers) {
            this.debugging.assertFormulaInContext(t);
        }
        BooleanFormula result = this.delegate.distinct(pNumbers);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterThan(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        BooleanFormula result = this.delegate.greaterThan(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula greaterOrEquals(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        BooleanFormula result = this.delegate.greaterOrEquals(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessThan(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        BooleanFormula result = this.delegate.lessThan(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula lessOrEquals(ParamFormulaType number1, ParamFormulaType number2) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)number1);
        this.debugging.assertFormulaInContext((Formula)number2);
        BooleanFormula result = this.delegate.lessOrEquals(number1, number2);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public NumeralFormula.IntegerFormula floor(ParamFormulaType formula) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext((Formula)formula);
        NumeralFormula.IntegerFormula result = this.delegate.floor(formula);
        this.debugging.addFormulaTerm(result);
        return result;
    }
}

