/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.debugging;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingAssertions;
import org.sosy_lab.java_smt.delegate.debugging.DebuggingNumeralFormulaManager;

public class DebuggingIntegerFormulaManager
extends DebuggingNumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    private final IntegerFormulaManager delegate;
    private final DebuggingAssertions debugging;

    public DebuggingIntegerFormulaManager(IntegerFormulaManager pDelegate, DebuggingAssertions pDebugging) {
        super(pDelegate, pDebugging);
        this.delegate = (IntegerFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.debugging = pDebugging;
    }

    @Override
    public BooleanFormula modularCongruence(NumeralFormula.IntegerFormula number1, NumeralFormula.IntegerFormula number2, BigInteger n) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.modularCongruence(number1, number2, n);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public BooleanFormula modularCongruence(NumeralFormula.IntegerFormula number1, NumeralFormula.IntegerFormula number2, long n) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(number1);
        this.debugging.assertFormulaInContext(number2);
        BooleanFormula result = this.delegate.modularCongruence(number1, number2, n);
        this.debugging.addFormulaTerm(result);
        return result;
    }

    @Override
    public NumeralFormula.IntegerFormula modulo(NumeralFormula.IntegerFormula numerator, NumeralFormula.IntegerFormula denominator) {
        this.debugging.assertThreadLocal();
        this.debugging.assertFormulaInContext(numerator);
        this.debugging.assertFormulaInContext(denominator);
        NumeralFormula.IntegerFormula result = this.delegate.modulo(numerator, denominator);
        this.debugging.addFormulaTerm(result);
        return result;
    }
}

