/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.SLFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractSLFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements SLFormulaManager {
    protected AbstractSLFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pCreator) {
        super(pCreator);
    }

    private BooleanFormula wrap(TFormulaInfo pTerm) {
        return this.getFormulaCreator().encapsulateBoolean(pTerm);
    }

    @Override
    public BooleanFormula makeStar(BooleanFormula f1, BooleanFormula f2) {
        Object param1 = this.extractInfo(f1);
        Object param2 = this.extractInfo(f2);
        return this.wrap(this.makeStar(param1, param2));
    }

    protected abstract TFormulaInfo makeStar(TFormulaInfo var1, TFormulaInfo var2);

    public BooleanFormula makePointsTo(Formula ptr, Formula to) {
        Object param1 = this.extractInfo(ptr);
        Object param2 = this.extractInfo(to);
        return this.wrap(this.makePointsTo(param1, param2));
    }

    protected abstract TFormulaInfo makePointsTo(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula makeMagicWand(BooleanFormula f1, BooleanFormula f2) {
        Object param1 = this.extractInfo(f1);
        Object param2 = this.extractInfo(f2);
        return this.wrap(this.makeMagicWand(param1, param2));
    }

    protected abstract TFormulaInfo makeMagicWand(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public <AF extends Formula, VF extends Formula, AT extends FormulaType<AF>, VT extends FormulaType<VF>> BooleanFormula makeEmptyHeap(AT pAdressType, VT pValueType) {
        Object adressType = this.toSolverType(pAdressType);
        Object valueType = this.toSolverType(pValueType);
        return this.wrap(this.makeEmptyHeap(adressType, valueType));
    }

    protected abstract TFormulaInfo makeEmptyHeap(TType var1, TType var2);

    @Override
    public <AF extends Formula, AT extends FormulaType<AF>> AF makeNilElement(AT pAdressType) {
        Object type = this.toSolverType(pAdressType);
        return (AF)this.getFormulaCreator().encapsulate(pAdressType, this.makeNilElement(type));
    }

    protected abstract TFormulaInfo makeNilElement(TType var1);
}

