/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Evaluator;
import org.sosy_lab.java_smt.api.SolverContext;

public abstract class AbstractProver<T>
implements BasicProverEnvironment<T> {
    private final boolean generateModels;
    private final boolean generateAllSat;
    protected final boolean generateUnsatCores;
    private final boolean generateUnsatCoresOverAssumptions;
    protected final boolean enableSL;
    protected boolean closed = false;
    private final Set<Evaluator> evaluators = new LinkedHashSet<Evaluator>();
    private final List<Multimap<BooleanFormula, T>> assertedFormulas = new ArrayList<Multimap<BooleanFormula, T>>();
    private static final String TEMPLATE = "Please set the prover option %s.";

    protected AbstractProver(Set<SolverContext.ProverOptions> pOptions) {
        this.generateModels = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS);
        this.generateAllSat = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_ALL_SAT);
        this.generateUnsatCores = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
        this.generateUnsatCoresOverAssumptions = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS);
        this.enableSL = pOptions.contains((Object)SolverContext.ProverOptions.ENABLE_SEPARATION_LOGIC);
        this.assertedFormulas.add((Multimap<BooleanFormula, T>)LinkedHashMultimap.create());
    }

    protected final void checkGenerateModels() {
        Preconditions.checkState((boolean)this.generateModels, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_MODELS));
    }

    protected final void checkGenerateAllSat() {
        Preconditions.checkState((boolean)this.generateAllSat, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_ALL_SAT));
    }

    protected final void checkGenerateUnsatCores() {
        Preconditions.checkState((boolean)this.generateUnsatCores, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE));
    }

    protected final void checkGenerateUnsatCoresOverAssumptions() {
        Preconditions.checkState((boolean)this.generateUnsatCoresOverAssumptions, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS));
    }

    protected final void checkEnableSeparationLogic() {
        Preconditions.checkState((boolean)this.enableSL, (String)TEMPLATE, (Object)((Object)SolverContext.ProverOptions.ENABLE_SEPARATION_LOGIC));
    }

    @Override
    public int size() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.assertedFormulas.size() - 1;
    }

    @Override
    public final void push() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.pushImpl();
        this.assertedFormulas.add((Multimap<BooleanFormula, T>)LinkedHashMultimap.create());
    }

    protected abstract void pushImpl() throws InterruptedException;

    @Override
    public final void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((this.assertedFormulas.size() > 1 ? 1 : 0) != 0, (Object)"initial level must remain until close");
        this.assertedFormulas.remove(this.assertedFormulas.size() - 1);
        this.popImpl();
    }

    protected abstract void popImpl();

    @Override
    @CanIgnoreReturnValue
    public final @Nullable T addConstraint(BooleanFormula constraint) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        T t = this.addConstraintImpl(constraint);
        ((Multimap)Iterables.getLast(this.assertedFormulas)).put((Object)constraint, t);
        return t;
    }

    protected abstract @Nullable T addConstraintImpl(BooleanFormula var1) throws InterruptedException;

    protected ImmutableSet<BooleanFormula> getAssertedFormulas() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Multimap<BooleanFormula, T> level : this.assertedFormulas) {
            builder.addAll((Iterable)level.keySet());
        }
        return builder.build();
    }

    protected ImmutableSet<T> getAssertedConstraintIds() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Multimap<BooleanFormula, T> level : this.assertedFormulas) {
            builder.addAll((Iterable)level.values());
        }
        return builder.build();
    }

    protected <E extends Evaluator> E registerEvaluator(E pEvaluator) {
        this.evaluators.add(pEvaluator);
        return pEvaluator;
    }

    protected void unregisterEvaluator(Evaluator pEvaluator) {
        this.evaluators.remove(pEvaluator);
    }

    protected void closeAllEvaluators() {
        this.evaluators.forEach(Evaluator::close);
        this.evaluators.clear();
    }

    @Override
    public void close() {
        this.assertedFormulas.clear();
        this.closeAllEvaluators();
        this.closed = true;
    }
}

