/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

public abstract class SolverStackTest0
extends SolverBasedTest0.ParameterizedSolverBasedTest0 {
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    protected abstract BasicProverEnvironment<?> newEnvironmentForTest(SolverContext var1, SolverContext.ProverOptions ... var2);

    protected void requireTheoryCombination() {
    }

    private void requireMultipleStackSupport() {
        TruthJUnit.assume().withMessage("Solver does not support multiple stacks yet").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
    }

    protected final void requireUfValuesInModel() {
        TruthJUnit.assume().withMessage("Integration of solver does not support retrieving values for UFs from a model").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.Z3);
    }

    @Test
    public void simpleStackTestBool() throws SolverException, InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        int i = index.getFreshId();
        BooleanFormula a = this.bmgr.makeVariable("bool_a" + i);
        BooleanFormula b = this.bmgr.makeVariable("bool_b" + i);
        BooleanFormula or = this.bmgr.or(a, b);
        stack.push(or);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        BooleanFormula c = this.bmgr.makeVariable("bool_c" + i);
        BooleanFormula d = this.bmgr.makeVariable("bool_d" + i);
        BooleanFormula and = this.bmgr.and(c, d);
        stack.push(and);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        BooleanFormula notOr = this.bmgr.not(or);
        stack.push(notOr);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)3);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.push(and);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.push(notOr);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
    }

    @Test
    public void singleStackTestInteger() throws SolverException, InterruptedException {
        this.requireIntegers();
        BasicProverEnvironment<?> env = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        this.simpleStackTestNum(this.imgr, env);
    }

    @Test
    public void singleStackTestRational() throws SolverException, InterruptedException {
        this.requireRationals();
        this.requireTheoryCombination();
        BasicProverEnvironment<?> env = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        this.simpleStackTestNum(this.rmgr, env);
    }

    private <X extends NumeralFormula, Y extends X> void simpleStackTestNum(NumeralFormulaManager<X, Y> nmgr, BasicProverEnvironment<?> stack) throws SolverException, InterruptedException {
        int i = index.getFreshId();
        Y a = nmgr.makeVariable("num_a" + i);
        Y b = nmgr.makeVariable("num_b" + i);
        BooleanFormula leqAB = nmgr.lessOrEquals(a, b);
        stack.push(leqAB);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        Y c = nmgr.makeVariable("num_c" + i);
        Y d = nmgr.makeVariable("num_d" + i);
        BooleanFormula eqCD = nmgr.lessOrEquals(c, d);
        stack.push(eqCD);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        BooleanFormula gtAB = nmgr.greaterThan(a, b);
        stack.push(gtAB);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)3);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.push(eqCD);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.push(gtAB);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
    }

    @Test
    public void stackTest() {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        Assert.assertThrows(RuntimeException.class, stack::pop);
    }

    @Test
    public void stackTest2() throws InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack.push();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
    }

    @Test
    public void stackTest3() throws InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack.push();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
        stack.push();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
    }

    @Test
    public void stackTest4() throws InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack.push();
        stack.push();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        stack.pop();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
    }

    @Test
    public void largeStackUsageTest() throws InterruptedException, SolverException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        for (int i = 0; i < 20; ++i) {
            Truth.assertThat((Integer)stack.size()).isEqualTo((Object)i);
            stack.push();
            stack.addConstraint(this.bmgr.equivalence(this.bmgr.makeVariable("X" + i), this.bmgr.makeVariable("X" + (i + 1))));
            stack.addConstraint(this.bmgr.equivalence(this.bmgr.makeVariable("Y" + i), this.bmgr.makeVariable("Y" + (i + 1))));
            stack.addConstraint(this.bmgr.equivalence(this.bmgr.makeVariable("X" + i), this.bmgr.makeVariable("Y" + i)));
        }
        Truth.assertThat((Boolean)stack.isUnsat()).isFalse();
    }

    @Test
    public void largerStackUsageTest() throws InterruptedException, SolverException {
        int n = 1000;
        if (ImmutableList.of((Object)((Object)SolverContextFactory.Solvers.PRINCESS), (Object)((Object)SolverContextFactory.Solvers.OPENSMT)).contains((Object)this.solverToUse())) {
            n = 50;
        }
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        for (int i = 0; i < n; ++i) {
            Truth.assertThat((Integer)stack.size()).isEqualTo((Object)i);
            stack.push();
            stack.addConstraint(this.bmgr.equivalence(this.bmgr.makeVariable("X" + i), this.bmgr.makeVariable("X" + (i + 1))));
            stack.addConstraint(this.bmgr.equivalence(this.bmgr.makeVariable("Y" + i), this.bmgr.makeVariable("Y" + (i + 1))));
            stack.addConstraint(this.bmgr.equivalence(this.bmgr.makeVariable("X" + i), this.bmgr.makeVariable("Y" + i)));
        }
        Truth.assertThat((Boolean)stack.isUnsat()).isFalse();
    }

    @Test
    public void stackTest5() throws InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack.push();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
        Assert.assertThrows(RuntimeException.class, stack::pop);
    }

    @Test
    public void stackTestUnsat() throws InterruptedException, SolverException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, SolverContext.ProverOptions.GENERATE_MODELS);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.push();
        stack.addConstraint(this.bmgr.makeFalse());
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.push();
        stack.addConstraint(this.bmgr.makeFalse());
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)2);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
    }

    @Test
    public void stackTestUnsat2() throws InterruptedException, SolverException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, SolverContext.ProverOptions.GENERATE_MODELS);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.push();
        stack.addConstraint(this.bmgr.makeTrue());
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.push();
        stack.addConstraint(this.bmgr.makeFalse());
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.push();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)3);
        stack.addConstraint(this.bmgr.makeFalse());
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.pop();
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
    }

    @Test
    public void symbolsOnStackTest() throws InterruptedException, SolverException {
        this.requireModel();
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, SolverContext.ProverOptions.GENERATE_MODELS);
        TestCase.assertEquals((int)0, (int)stack.size());
        stack.push();
        TestCase.assertEquals((int)1, (int)stack.size());
        BooleanFormula q1 = this.bmgr.makeVariable("q");
        stack.addConstraint(q1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        Model m1 = stack.getModel();
        Truth.assertThat((Iterable)m1).isNotEmpty();
        stack.pop();
        TestCase.assertEquals((int)0, (int)stack.size());
        stack.push();
        TestCase.assertEquals((int)1, (int)stack.size());
        BooleanFormula q2 = this.bmgr.makeVariable("q");
        Truth.assertThat((Object)q2).isEqualTo((Object)q1);
        stack.addConstraint(q1);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        Model m2 = stack.getModel();
        Truth.assertThat((Iterable)m2).isNotEmpty();
        stack.pop();
        TestCase.assertEquals((int)0, (int)stack.size());
    }

    @Test
    public void constraintTestBool1() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            stack.addConstraint(a);
            Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        }
        try (BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            stack2.addConstraint(this.bmgr.not(a));
            Truth.assertThat((Integer)stack2.size()).isEqualTo((Object)0);
            ProverEnvironmentSubject.assertThat(stack2).isSatisfiable();
        }
    }

    @Test
    public void constraintTestBool2() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            stack.push(a);
            Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        }
        try (BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            stack2.addConstraint(this.bmgr.not(a));
            Truth.assertThat((Integer)stack2.size()).isEqualTo((Object)0);
            ProverEnvironmentSubject.assertThat(stack2).isSatisfiable();
        }
    }

    @Test
    public void constraintTestBool3() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
            stack.push(a);
            Truth.assertThat((Integer)stack.size()).isEqualTo((Object)1);
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        }
        try (BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            Truth.assertThat((Integer)stack2.size()).isEqualTo((Object)0);
            Assert.assertThrows(RuntimeException.class, stack2::pop);
        }
    }

    @Test
    public void constraintTestBool4() throws SolverException, InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack.addConstraint(this.bmgr.makeVariable("bool_a"));
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
        Assert.assertThrows(RuntimeException.class, stack::pop);
    }

    @Test
    public void satTestBool5() throws SolverException, InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        Truth.assertThat((Integer)stack.size()).isEqualTo((Object)0);
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
    }

    @Test
    public void dualStackTest() throws SolverException, InterruptedException {
        this.requireMultipleStackSupport();
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        BooleanFormula not = this.bmgr.not(a);
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack1.push(a);
        stack1.push(a);
        Truth.assertThat((Integer)stack1.size()).isEqualTo((Object)2);
        BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack1.pop();
        stack1.pop();
        Truth.assertThat((Integer)stack1.size()).isEqualTo((Object)0);
        stack1.push(a);
        Truth.assertThat((Integer)stack1.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack1).isSatisfiable();
        stack2.push(not);
        Truth.assertThat((Integer)stack2.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack2).isSatisfiable();
        stack1.pop();
        stack2.pop();
        Truth.assertThat((Integer)stack1.size()).isEqualTo((Object)0);
        Truth.assertThat((Integer)stack2.size()).isEqualTo((Object)0);
    }

    @Test
    public void dualStackTest2() throws SolverException, InterruptedException {
        this.requireMultipleStackSupport();
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        BooleanFormula not = this.bmgr.not(a);
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack1.push(a);
        stack1.push(this.bmgr.makeBoolean(true));
        ProverEnvironmentSubject.assertThat(stack1).isSatisfiable();
        stack2.push(not);
        Truth.assertThat((Integer)stack1.size()).isEqualTo((Object)2);
        Truth.assertThat((Integer)stack2.size()).isEqualTo((Object)1);
        ProverEnvironmentSubject.assertThat(stack2).isSatisfiable();
        stack1.pop();
        ProverEnvironmentSubject.assertThat(stack1).isSatisfiable();
        stack1.pop();
        ProverEnvironmentSubject.assertThat(stack1).isSatisfiable();
        stack2.pop();
        ProverEnvironmentSubject.assertThat(stack2).isSatisfiable();
        ProverEnvironmentSubject.assertThat(stack1).isSatisfiable();
        Truth.assertThat((Integer)stack1.size()).isEqualTo((Object)0);
        Truth.assertThat((Integer)stack2.size()).isEqualTo((Object)0);
    }

    @Test
    public void multiStackTest() throws SolverException, InterruptedException {
        int i;
        this.requireMultipleStackSupport();
        int limit = 10;
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        BooleanFormula not = this.bmgr.not(a);
        ArrayList stacks = new ArrayList();
        for (i = 0; i < limit; ++i) {
            stacks.add(this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]));
        }
        for (i = 0; i < limit; ++i) {
            ((BasicProverEnvironment)stacks.get(i)).push(a);
            ((BasicProverEnvironment)stacks.get(i)).push(this.bmgr.makeBoolean(true));
            ProverEnvironmentSubject.assertThat((BasicProverEnvironment)stacks.get(i)).isSatisfiable();
            Truth.assertThat((Integer)((BasicProverEnvironment)stacks.get(i)).size()).isEqualTo((Object)2);
            ((BasicProverEnvironment)stacks.get(i)).push();
            ((BasicProverEnvironment)stacks.get(i)).push();
            Truth.assertThat((Integer)((BasicProverEnvironment)stacks.get(i)).size()).isEqualTo((Object)4);
            ((BasicProverEnvironment)stacks.get(i)).pop();
            ((BasicProverEnvironment)stacks.get(i)).pop();
        }
        for (i = 0; i < limit; ++i) {
            ((BasicProverEnvironment)stacks.get(i)).push(not);
            ProverEnvironmentSubject.assertThat((BasicProverEnvironment)stacks.get(i)).isUnsatisfiable();
            Truth.assertThat((Integer)((BasicProverEnvironment)stacks.get(i)).size()).isEqualTo((Object)3);
            ((BasicProverEnvironment)stacks.get(i)).pop();
            Truth.assertThat((Integer)((BasicProverEnvironment)stacks.get(i)).size()).isEqualTo((Object)2);
        }
        for (i = 0; i < limit; ++i) {
            ((BasicProverEnvironment)stacks.get(i)).pop();
            Truth.assertThat((Integer)((BasicProverEnvironment)stacks.get(i)).size()).isEqualTo((Object)1);
            ((BasicProverEnvironment)stacks.get(i)).close();
        }
    }

    @Test(expected=IllegalStateException.class)
    public void avoidDualStacksIfNotSupported() throws InterruptedException {
        TruthJUnit.assume().withMessage("Solver does not support multiple stacks yet").that((Comparable)((Object)this.solver)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack1.push(this.bmgr.makeTrue());
        this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
    }

    @Test
    public void dualStackGlobalDeclarations() throws SolverException, InterruptedException {
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);
        stack1.push(this.bmgr.makeVariable("bool_a"));
        String varName = "bool_b";
        BooleanFormula b = this.bmgr.makeVariable("bool_b");
        stack1.push(b);
        ProverEnvironmentSubject.assertThat(stack1).isSatisfiable();
        stack1.pop();
        stack1.pop();
        Truth.assertThat((Integer)stack1.size()).isEqualTo((Object)0);
        stack1.close();
        Assert.assertThrows(IllegalStateException.class, stack1::size);
        this.assertThatFormula(b).isEquivalentTo(this.bmgr.makeVariable("bool_b"));
    }

    @Test
    public void modelForUnsatFormula() throws SolverException, InterruptedException {
        this.requireIntegers();
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            stack.push(this.imgr.greaterThan((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
            stack.push(this.imgr.lessThan((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
            ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
            Assert.assertThrows(Exception.class, stack::getModel);
        }
    }

    @Test
    public void modelForUnsatFormula2() throws SolverException, InterruptedException {
        this.requireIntegers();
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, new SolverContext.ProverOptions[0]);){
            stack.push(this.imgr.greaterThan((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
            stack.push(this.imgr.lessThan((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
            ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
            Assert.assertThrows(Exception.class, stack::getModel);
        }
    }

    @Test
    public void modelForSatFormula() throws SolverException, InterruptedException {
        this.requireIntegers();
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
            stack.push(this.imgr.greaterThan(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
            stack.push(this.imgr.lessThan(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
            Model model = stack.getModel();
            Truth.assertThat((Comparable)model.evaluate(a)).isEqualTo((Object)BigInteger.ONE);
        }
    }

    @Test
    public void modelForSatFormulaWithLargeValue() throws SolverException, InterruptedException {
        this.requireIntegers();
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, SolverContext.ProverOptions.GENERATE_MODELS);){
            BigInteger val = BigInteger.TEN.pow(1000);
            NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
            stack.push(this.imgr.equal(a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(val)));
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
            Model model = stack.getModel();
            Truth.assertThat((Comparable)model.evaluate(a)).isEqualTo((Object)val);
        }
    }

    @Test
    public void modelForSatFormulaWithUF() throws SolverException, InterruptedException {
        this.requireIntegers();
        this.requireTheoryCombination();
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
            NumeralFormula.IntegerFormula varA = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
            NumeralFormula.IntegerFormula varB = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
            stack.push(this.imgr.equal(varA, zero));
            stack.push(this.imgr.equal(varB, zero));
            FunctionDeclaration<NumeralFormula.IntegerFormula> uf = this.fmgr.declareUF("uf", FormulaType.IntegerType, FormulaType.IntegerType);
            stack.push(this.imgr.equal(this.fmgr.callUF(uf, varB), zero));
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
            Model model = stack.getModel();
            Truth.assertThat((Comparable)model.evaluate(varA)).isEqualTo((Object)BigInteger.ZERO);
            Truth.assertThat((Comparable)model.evaluate(varB)).isEqualTo((Object)BigInteger.ZERO);
            this.requireUfValuesInModel();
            Truth.assertThat((Comparable)model.evaluate(this.fmgr.callUF(uf, new Formula[]{this.imgr.makeNumber(BigDecimal.ZERO)}))).isEqualTo((Object)BigInteger.ZERO);
        }
    }

    @Test
    public void multiCloseTest() throws SolverException, InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(this.context, SolverContext.ProverOptions.GENERATE_MODELS);
        try {
            stack.push();
            stack.pop();
            stack.push(this.bmgr.equivalence(this.bmgr.makeVariable("a"), this.bmgr.makeTrue()));
            ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
            stack.push();
        }
        finally {
            for (int i = 0; i < 10; ++i) {
                stack.close();
                Assert.assertThrows(IllegalStateException.class, stack::size);
                Assert.assertThrows(IllegalStateException.class, stack::push);
                Assert.assertThrows(IllegalStateException.class, stack::pop);
            }
        }
    }
}

