/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolNumeralFormulaManager;

class SmtInterpolRationalFormulaManager
extends SmtInterpolNumeralFormulaManager<NumeralFormula, NumeralFormula.RationalFormula>
implements RationalFormulaManager {
    SmtInterpolRationalFormulaManager(SmtInterpolFormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
    }

    @Override
    protected Term makeNumberImpl(long i) {
        return this.env.decimal(BigDecimal.valueOf(i));
    }

    @Override
    protected Term makeNumberImpl(BigInteger pI) {
        return this.env.decimal(new BigDecimal(pI));
    }

    @Override
    protected Term makeNumberImpl(String pI) {
        return this.env.decimal(pI);
    }

    @Override
    protected Term makeNumberImpl(Rational pI) {
        return this.env.getTheory().rational(de.uni_freiburg.informatik.ultimate.logic.Rational.valueOf((BigInteger)pI.getNum(), (BigInteger)pI.getDen()), this.env.getTheory().getRealSort());
    }

    @Override
    protected Term makeNumberImpl(double pNumber) {
        return this.env.decimal(BigDecimal.valueOf(pNumber));
    }

    @Override
    protected Term makeNumberImpl(BigDecimal pNumber) {
        return this.env.decimal(pNumber);
    }

    @Override
    protected Term makeVariableImpl(String varName) {
        Sort t = (Sort)this.getFormulaCreator().getRationalType();
        return (Term)this.getFormulaCreator().makeVariable(t, varName);
    }

    @Override
    public Term divide(Term pNumber1, Term pNumber2) {
        if (this.consistsOfNumerals(pNumber2)) {
            Sort intSort = pNumber1.getTheory().getNumericSort();
            Sort realSort = pNumber1.getTheory().getRealSort();
            assert (intSort.equals(pNumber1.getSort()) || realSort.equals(pNumber1.getSort()));
            assert (intSort.equals(pNumber2.getSort()) || realSort.equals(pNumber2.getSort()));
            return this.env.term("/", new Term[]{pNumber1, pNumber2});
        }
        return super.divide(pNumber1, pNumber2);
    }

    @Override
    protected Term floor(Term pNumber) {
        return this.env.term("to_int", new Term[]{pNumber});
    }
}

