/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.collect.Iterables;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ParseEnvironment;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.FormulaCollectionScript;
import org.sosy_lab.java_smt.solvers.smtinterpol.LogProxyForwarder;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolRationalFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolUFManager;

public class SmtInterpolFormulaManager
extends AbstractFormulaManager<Term, Sort, Script, FunctionSymbol> {
    private final LogManager logger;

    SmtInterpolFormulaManager(SmtInterpolFormulaCreator pCreator, SmtInterpolUFManager pFunctionManager, SmtInterpolBooleanFormulaManager pBooleanManager, SmtInterpolIntegerFormulaManager pIntegerManager, SmtInterpolRationalFormulaManager pRationalManager, SmtInterpolArrayFormulaManager pArrayFormulaManager, LogManager pLogger) {
        super(pCreator, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, null, null, null, pArrayFormulaManager, null, null, null);
        this.logger = pLogger;
    }

    BooleanFormula encapsulateBooleanFormula(Term t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        FormulaCollectionScript parseScript = new FormulaCollectionScript((Script)this.getEnvironment(), ((Script)this.getEnvironment()).getTheory());
        LogProxyForwarder logProxy = new LogProxyForwarder(this.logger.withComponentName("SMTInterpol"));
        ParseEnvironment parseEnv = new ParseEnvironment(parseScript, new OptionMap((LogProxy)logProxy, true)){

            public void printError(String pMessage) {
                throw new SMTLIBException(pMessage);
            }

            public void printSuccess() {
            }
        };
        try {
            parseEnv.parseStream((Reader)new StringReader(pS), "<stdin>");
        }
        catch (SMTLIBException nested) {
            throw new IllegalArgumentException(nested);
        }
        Term term = (Term)Iterables.getOnlyElement(parseScript.getAssertedTerms());
        return this.encapsulateBooleanFormula(new FormulaUnLet().unlet(term));
    }

    @Override
    public Appender dumpFormula(final Term formula) {
        assert (this.getFormulaCreator().getFormulaType(formula) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                HashSet<Term> seen = new HashSet<Term>();
                HashSet<FunctionSymbol> declaredFunctions = new HashSet<FunctionSymbol>();
                ArrayDeque<Term> todo = new ArrayDeque<Term>();
                PrintTerm termPrinter = new PrintTerm();
                todo.addLast(formula);
                while (!todo.isEmpty()) {
                    Term t = (Term)todo.removeLast();
                    while (t instanceof AnnotatedTerm) {
                        t = ((AnnotatedTerm)t).getSubterm();
                    }
                    if (!(t instanceof ApplicationTerm) || !seen.add(t)) continue;
                    ApplicationTerm term = (ApplicationTerm)t;
                    Collections.addAll(todo, term.getParameters());
                    FunctionSymbol func = term.getFunction();
                    if (func.isIntern()) continue;
                    if (func.getDefinition() == null) {
                        if (!declaredFunctions.add(func)) continue;
                        out.append("(declare-fun ");
                        out.append(PrintTerm.quoteIdentifier((String)func.getName()));
                        out.append(" (");
                        int counter = 0;
                        for (Sort paramSort : func.getParameterSorts()) {
                            termPrinter.append(out, paramSort);
                            if (++counter >= func.getParameterSorts().length) continue;
                            out.append(' ');
                        }
                        out.append(") ");
                        termPrinter.append(out, func.getReturnSort());
                        out.append(")\n");
                        continue;
                    }
                    throw new IllegalArgumentException("Terms with definition are unsupported.");
                }
                out.append("(assert ");
                Term letted = new FormulaLet().let(formula);
                termPrinter.append(out, letted);
                out.append(")");
            }
        };
    }

    @Override
    public Term simplify(Term pF) {
        SimplifyDDA s = new SimplifyDDA((Script)this.getEnvironment(), true);
        return s.getSimplifiedTerm(pF);
    }
}

