/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.basetypes.IdealInt;
import ap.parser.IExpression;
import ap.parser.ITerm;
import ap.theories.bitvectors.ModuloArithmetic$;
import ap.types.Sort;
import ap.types.Sort$;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.java_smt.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFunctionDeclaration;
import scala.Option;

class PrincessBitvectorFormulaManager
extends AbstractBitvectorFormulaManager<IExpression, Sort, PrincessEnvironment, PrincessFunctionDeclaration> {
    PrincessBitvectorFormulaManager(PrincessFormulaCreator pCreator, PrincessBooleanFormulaManager pBmgr) {
        super(pCreator, pBmgr);
    }

    @Override
    protected IExpression negate(IExpression pParam1) {
        return ModuloArithmetic$.MODULE$.bvneg((ITerm)pParam1);
    }

    @Override
    protected IExpression add(IExpression pParam1, IExpression pParam2) {
        return ModuloArithmetic$.MODULE$.bvadd((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression subtract(IExpression pParam1, IExpression pParam2) {
        return ModuloArithmetic$.MODULE$.bvsub((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression divide(IExpression pParam1, IExpression pParam2, boolean signed) {
        if (signed) {
            return ModuloArithmetic$.MODULE$.bvsdiv((ITerm)pParam1, (ITerm)pParam2);
        }
        return ModuloArithmetic$.MODULE$.bvudiv((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression modulo(IExpression pParam1, IExpression pParam2, boolean signed) {
        if (signed) {
            return ModuloArithmetic$.MODULE$.bvsrem((ITerm)pParam1, (ITerm)pParam2);
        }
        return ModuloArithmetic$.MODULE$.bvurem((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression multiply(IExpression pParam1, IExpression pParam2) {
        return ModuloArithmetic$.MODULE$.bvmul((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression equal(IExpression pParam1, IExpression pParam2) {
        return ((ITerm)pParam1).$eq$eq$eq((ITerm)pParam2);
    }

    @Override
    protected IExpression greaterThan(IExpression pParam1, IExpression pParam2, boolean signed) {
        return this.lessThan(pParam2, pParam1, signed);
    }

    @Override
    protected IExpression greaterOrEquals(IExpression pParam1, IExpression pParam2, boolean signed) {
        return this.lessOrEquals(pParam2, pParam1, signed);
    }

    @Override
    protected IExpression lessThan(IExpression pParam1, IExpression pParam2, boolean signed) {
        if (signed) {
            return ModuloArithmetic$.MODULE$.bvslt((ITerm)pParam1, (ITerm)pParam2);
        }
        return ModuloArithmetic$.MODULE$.bvult((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression lessOrEquals(IExpression pParam1, IExpression pParam2, boolean signed) {
        if (signed) {
            return ModuloArithmetic$.MODULE$.bvsle((ITerm)pParam1, (ITerm)pParam2);
        }
        return ModuloArithmetic$.MODULE$.bvule((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression not(IExpression pParam1) {
        return ModuloArithmetic$.MODULE$.bvnot((ITerm)pParam1);
    }

    @Override
    protected IExpression and(IExpression pParam1, IExpression pParam2) {
        return ModuloArithmetic$.MODULE$.bvand((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression or(IExpression pParam1, IExpression pParam2) {
        return ModuloArithmetic$.MODULE$.bvor((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression xor(IExpression pParam1, IExpression pParam2) {
        return ModuloArithmetic$.MODULE$.bvxor((ITerm)pParam1, (ITerm)pParam2);
    }

    @Override
    protected IExpression makeBitvectorImpl(int pLength, BigInteger pI) {
        pI = this.transformValueToRange(pLength, pI);
        return ModuloArithmetic$.MODULE$.bv(pLength, IdealInt.apply((BigInteger)pI));
    }

    @Override
    protected IExpression makeBitvectorImpl(int pLength, IExpression pIntegerFormula) {
        return ModuloArithmetic$.MODULE$.cast2UnsignedBV(pLength, (ITerm)pIntegerFormula);
    }

    @Override
    protected IExpression toIntegerFormulaImpl(IExpression pBVFormula, boolean signed) {
        BigInteger max;
        BigInteger min;
        Sort sort = Sort$.MODULE$.sortOf((ITerm)pBVFormula);
        Option<Object> bitWidth = PrincessEnvironment.getBitWidth(sort);
        Preconditions.checkArgument((boolean)bitWidth.isDefined());
        int size = (Integer)bitWidth.get();
        if (signed) {
            min = BigInteger.ONE.shiftLeft(size - 1).negate();
            max = BigInteger.ONE.shiftLeft(size - 1).subtract(BigInteger.ONE);
        } else {
            min = BigInteger.ZERO;
            max = BigInteger.ONE.shiftLeft(size).subtract(BigInteger.ONE);
        }
        ITerm bvInRange = ModuloArithmetic$.MODULE$.cast2Interval(IdealInt.apply((BigInteger)min), IdealInt.apply((BigInteger)max), (ITerm)pBVFormula);
        return IExpression.i((int)0).$plus(bvInRange);
    }

    @Override
    protected IExpression makeVariableImpl(int pLength, String pVar) {
        Sort t = (Sort)this.getFormulaCreator().getBitvectorType(pLength);
        return (IExpression)this.getFormulaCreator().makeVariable(t, pVar);
    }

    @Override
    protected IExpression shiftRight(IExpression pNumber, IExpression toShift, boolean signed) {
        if (signed) {
            return ModuloArithmetic$.MODULE$.bvashr((ITerm)pNumber, (ITerm)toShift);
        }
        return ModuloArithmetic$.MODULE$.bvlshr((ITerm)pNumber, (ITerm)toShift);
    }

    @Override
    protected IExpression shiftLeft(IExpression pExtract, IExpression pExtract2) {
        return ModuloArithmetic$.MODULE$.bvshl((ITerm)pExtract, (ITerm)pExtract2);
    }

    @Override
    protected IExpression concat(IExpression number, IExpression pAppend) {
        return ModuloArithmetic$.MODULE$.concat((ITerm)number, (ITerm)pAppend);
    }

    @Override
    protected IExpression extract(IExpression pNumber, int pMsb, int pLsb) {
        return ModuloArithmetic$.MODULE$.extract(pMsb, pLsb, (ITerm)pNumber);
    }

    @Override
    protected IExpression extend(IExpression pNumber, int pExtensionBits, boolean pSigned) {
        if (pSigned) {
            return ModuloArithmetic$.MODULE$.sign_extend(pExtensionBits, (ITerm)pNumber);
        }
        return ModuloArithmetic$.MODULE$.zero_extend(pExtensionBits, (ITerm)pNumber);
    }
}

