/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.function.Consumer;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.solvers.opensmt.Logics;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtInterpolatingProver;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtRationalFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtTheoremProver;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtUFManager;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.LogicFactory;

public class OpenSmtSolverContext
extends AbstractSolverContext {
    private final OpenSmtFormulaCreator creator;
    private final OpenSmtFormulaManager manager;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final OpenSMTOptions solverOptions;
    private boolean closed = false;

    private OpenSmtSolverContext(OpenSmtFormulaCreator pCreator, OpenSmtFormulaManager pManager, LogManager pLogger, ShutdownNotifier pShutdownNotifier, OpenSMTOptions pSolverOptions) {
        super(pManager);
        this.creator = pCreator;
        this.manager = pManager;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.solverOptions = pSolverOptions;
    }

    public static SolverContext create(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier, long pRandom, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic, Consumer<String> pLoader) throws InvalidConfigurationException {
        pLoader.accept("opensmt");
        pLoader.accept("opensmtjava");
        OpenSMTOptions solverOptions = new OpenSMTOptions(config, (int)pRandom);
        OpenSmtFormulaCreator creator = OpenSmtFormulaCreator.create(solverOptions.logic);
        OpenSmtUFManager functionTheory = new OpenSmtUFManager(creator);
        OpenSmtBooleanFormulaManager booleanTheory = new OpenSmtBooleanFormulaManager(creator);
        OpenSmtIntegerFormulaManager integerTheory = new OpenSmtIntegerFormulaManager(creator, pNonLinearArithmetic);
        OpenSmtRationalFormulaManager rationalTheory = new OpenSmtRationalFormulaManager(creator, pNonLinearArithmetic);
        OpenSmtArrayFormulaManager arrayTheory = new OpenSmtArrayFormulaManager(creator);
        OpenSmtFormulaManager manager = new OpenSmtFormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, arrayTheory);
        return new OpenSmtSolverContext(creator, manager, pLogger, pShutdownNotifier, solverOptions);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            ((Logic)this.creator.getEnv()).delete();
        }
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.OPENSMT;
    }

    @Override
    public String getVersion() {
        return "OpenSMT " + LogicFactory.getVersion();
    }

    @Override
    protected OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        throw new UnsupportedOperationException("OpenSMT does not support optimization.");
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> pProverOptions) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        return new OpenSmtTheoremProver(this.creator, (FormulaManager)this.manager, this.shutdownNotifier, pProverOptions, this.solverOptions);
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> pProverOptions) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        return new OpenSmtInterpolatingProver(this.creator, (FormulaManager)this.manager, this.shutdownNotifier, pProverOptions, this.solverOptions);
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return false;
    }

    @Options(prefix="solver.opensmt")
    static class OpenSMTOptions {
        @Option(secure=true, description="SMT-LIB2 name of the logic to be used by the solver.")
        Logics logic = Logics.QF_AUFLIRA;
        @Option(secure=true, description="Algorithm for boolean interpolation")
        int algBool = 0;
        @Option(secure=true, description="Algorithm for UF interpolation")
        int algUf = 0;
        @Option(secure=true, description="Algorithm for LRA interpolation")
        int algLra = 0;
        final int randomSeed;

        OpenSMTOptions(Configuration config, int pRandomSeed) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.randomSeed = pRandomSeed;
        }
    }
}

