/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.opensmt;

import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.opensmt.OpenSmtFormulaCreator;
import org.sosy_lab.java_smt.solvers.opensmt.api.ArithLogic;
import org.sosy_lab.java_smt.solvers.opensmt.api.Logic;
import org.sosy_lab.java_smt.solvers.opensmt.api.PTRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.SymRef;
import org.sosy_lab.java_smt.solvers.opensmt.api.VectorPTRef;

abstract class OpenSmtNumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<PTRef, SRef, Logic, ParamFormulaType, ResultFormulaType, SymRef> {
    protected final ArithLogic osmtLogic;

    OpenSmtNumeralFormulaManager(OpenSmtFormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
        this.osmtLogic = (ArithLogic)pCreator.getEnv();
    }

    protected abstract SRef getNumeralType();

    @Override
    protected boolean isNumeral(PTRef pVal) {
        return this.osmtLogic.isNumConst(pVal);
    }

    @Override
    protected PTRef makeNumberImpl(long i) {
        return this.makeNumberImpl(Long.toString(i));
    }

    @Override
    protected PTRef makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected PTRef makeNumberImpl(String pI) {
        SRef type = this.getNumeralType();
        return this.osmtLogic.mkConst(type, pI);
    }

    @Override
    protected PTRef makeVariableImpl(String varName) {
        SRef type = this.getNumeralType();
        try {
            return (PTRef)this.getFormulaCreator().makeVariable(type, varName);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    protected PTRef multiply(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkTimes(pParam1, pParam2);
    }

    @Override
    protected PTRef modulo(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkMod(pParam1, pParam2);
    }

    @Override
    protected PTRef negate(PTRef pParam1) {
        return this.osmtLogic.mkNeg(pParam1);
    }

    @Override
    protected PTRef add(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkPlus(pParam1, pParam2);
    }

    @Override
    protected PTRef subtract(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkMinus(pParam1, pParam2);
    }

    @Override
    protected PTRef equal(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkEq(pParam1, pParam2);
    }

    @Override
    protected PTRef greaterThan(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkGt(pParam1, pParam2);
    }

    @Override
    protected PTRef greaterOrEquals(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkGeq(pParam1, pParam2);
    }

    @Override
    protected PTRef lessThan(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkLt(pParam1, pParam2);
    }

    @Override
    protected PTRef lessOrEquals(PTRef pParam1, PTRef pParam2) {
        return this.osmtLogic.mkLeq(pParam1, pParam2);
    }

    @Override
    protected PTRef distinctImpl(List<PTRef> pParam) {
        return this.osmtLogic.mkDistinct(new VectorPTRef(pParam));
    }
}

