/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

class Mathsat5FloatingPointFormulaManager
extends AbstractFloatingPointFormulaManager<Long, Long, Long, Long> {
    private final long mathsatEnv;
    private final long roundingMode;

    Mathsat5FloatingPointFormulaManager(Mathsat5FormulaCreator pCreator, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        super(pCreator);
        this.mathsatEnv = (Long)pCreator.getEnv();
        this.roundingMode = this.getRoundingModeImpl(pFloatingPointRoundingMode);
    }

    @Override
    protected Long getDefaultRoundingMode() {
        return this.roundingMode;
    }

    @Override
    protected Long getRoundingModeImpl(FloatingPointRoundingMode pFloatingPointRoundingMode) {
        switch (pFloatingPointRoundingMode) {
            case NEAREST_TIES_TO_EVEN: {
                return Mathsat5NativeApi.msat_make_fp_roundingmode_nearest_even(this.mathsatEnv);
            }
            case NEAREST_TIES_AWAY: {
                throw new IllegalArgumentException("Rounding mode NEAREST_TIES_AWAY is not supported by Mathsat5");
            }
            case TOWARD_POSITIVE: {
                return Mathsat5NativeApi.msat_make_fp_roundingmode_plus_inf(this.mathsatEnv);
            }
            case TOWARD_NEGATIVE: {
                return Mathsat5NativeApi.msat_make_fp_roundingmode_minus_inf(this.mathsatEnv);
            }
            case TOWARD_ZERO: {
                return Mathsat5NativeApi.msat_make_fp_roundingmode_zero(this.mathsatEnv);
            }
        }
        throw new AssertionError((Object)"Unexpected branch");
    }

    @Override
    protected Long makeNumberImpl(double pN, FormulaType.FloatingPointType pType, Long pRoundingMode) {
        return this.makeNumberImpl(Double.toString(pN), pType, pRoundingMode);
    }

    @Override
    protected Long makeNumberAndRound(String pN, FormulaType.FloatingPointType pType, Long pRoundingMode) {
        try {
            if (Mathsat5FloatingPointFormulaManager.isNegativeZero(Double.valueOf(pN))) {
                return Mathsat5NativeApi.msat_make_fp_neg(this.mathsatEnv, Mathsat5NativeApi.msat_make_fp_rat_number(this.mathsatEnv, "0", pType.getExponentSize(), pType.getMantissaSize(), pRoundingMode));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Mathsat5NativeApi.msat_make_fp_rat_number(this.mathsatEnv, pN, pType.getExponentSize(), pType.getMantissaSize(), pRoundingMode);
    }

    @Override
    protected Long makeVariableImpl(String var, FormulaType.FloatingPointType type) {
        return (Long)this.getFormulaCreator().makeVariable((Long)this.getFormulaCreator().getFloatingPointType(type), var);
    }

    @Override
    protected Long makePlusInfinityImpl(FormulaType.FloatingPointType type) {
        return Mathsat5NativeApi.msat_make_fp_plus_inf(this.mathsatEnv, type.getExponentSize(), type.getMantissaSize());
    }

    @Override
    protected Long makeMinusInfinityImpl(FormulaType.FloatingPointType type) {
        return Mathsat5NativeApi.msat_make_fp_minus_inf(this.mathsatEnv, type.getExponentSize(), type.getMantissaSize());
    }

    @Override
    protected Long makeNaNImpl(FormulaType.FloatingPointType type) {
        return Mathsat5NativeApi.msat_make_fp_nan(this.mathsatEnv, type.getExponentSize(), type.getMantissaSize());
    }

    @Override
    protected Long castToImpl(Long pNumber, boolean pSigned, FormulaType<?> pTargetType, Long pRoundingMode) {
        if (pTargetType.isFloatingPointType()) {
            FormulaType.FloatingPointType targetType = (FormulaType.FloatingPointType)pTargetType;
            return Mathsat5NativeApi.msat_make_fp_cast(this.mathsatEnv, targetType.getExponentSize(), targetType.getMantissaSize(), pRoundingMode, pNumber);
        }
        if (pTargetType.isBitvectorType()) {
            FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)pTargetType;
            if (pSigned) {
                return Mathsat5NativeApi.msat_make_fp_to_sbv(this.mathsatEnv, targetType.getSize(), pRoundingMode, pNumber);
            }
            return Mathsat5NativeApi.msat_make_fp_to_ubv(this.mathsatEnv, targetType.getSize(), pRoundingMode, pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    @Override
    protected Long castFromImpl(Long pNumber, boolean pSigned, FormulaType.FloatingPointType pTargetType, Long pRoundingMode) {
        FormulaType<?> formulaType = this.getFormulaCreator().getFormulaType(pNumber);
        if (formulaType.isFloatingPointType()) {
            return this.castToImpl(pNumber, pSigned, (FormulaType<?>)pTargetType, pRoundingMode);
        }
        if (formulaType.isBitvectorType()) {
            if (pSigned) {
                return Mathsat5NativeApi.msat_make_fp_from_sbv(this.mathsatEnv, pTargetType.getExponentSize(), pTargetType.getMantissaSize(), pRoundingMode, pNumber);
            }
            return Mathsat5NativeApi.msat_make_fp_from_ubv(this.mathsatEnv, pTargetType.getExponentSize(), pTargetType.getMantissaSize(), pRoundingMode, pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    private Long genericCast(Long pNumber, FormulaType<?> pTargetType) {
        long msatArgType = Mathsat5NativeApi.msat_term_get_type(pNumber);
        FormulaType<?> argType = this.getFormulaCreator().getFormulaType(pNumber);
        long castFuncDecl = (Long)this.getFormulaCreator().declareUFImpl("__cast_" + argType + "_to_" + pTargetType, (Long)this.toSolverType(pTargetType), (List<Long>)ImmutableList.of((Object)msatArgType));
        return Mathsat5NativeApi.msat_make_uf(this.mathsatEnv, castFuncDecl, new long[]{pNumber});
    }

    @Override
    protected Long fromIeeeBitvectorImpl(Long pNumber, FormulaType.FloatingPointType pTargetType) {
        return Mathsat5NativeApi.msat_make_fp_from_ieeebv(this.mathsatEnv, pTargetType.getExponentSize(), pTargetType.getMantissaSize(), pNumber);
    }

    @Override
    protected Long toIeeeBitvectorImpl(Long pNumber) {
        return Mathsat5NativeApi.msat_make_fp_as_ieeebv(this.mathsatEnv, pNumber);
    }

    @Override
    protected Long negate(Long pNumber) {
        return Mathsat5NativeApi.msat_make_fp_neg(this.mathsatEnv, pNumber);
    }

    @Override
    protected Long abs(Long pNumber) {
        return Mathsat5NativeApi.msat_make_fp_abs(this.mathsatEnv, pNumber);
    }

    @Override
    protected Long max(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_max(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long min(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_min(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long sqrt(Long pNumber, Long pRoundingMode) {
        return Mathsat5NativeApi.msat_make_fp_sqrt(this.mathsatEnv, pRoundingMode, pNumber);
    }

    @Override
    protected Long add(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Mathsat5NativeApi.msat_make_fp_plus(this.mathsatEnv, pRoundingMode, pNumber1, pNumber2);
    }

    @Override
    protected Long subtract(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Mathsat5NativeApi.msat_make_fp_minus(this.mathsatEnv, pRoundingMode, pNumber1, pNumber2);
    }

    @Override
    protected Long multiply(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Mathsat5NativeApi.msat_make_fp_times(this.mathsatEnv, pRoundingMode, pNumber1, pNumber2);
    }

    @Override
    protected Long divide(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Mathsat5NativeApi.msat_make_fp_div(this.mathsatEnv, pRoundingMode, pNumber1, pNumber2);
    }

    @Override
    protected Long assignment(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long equalWithFPSemantics(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long greaterThan(Long pNumber1, Long pNumber2) {
        return this.lessThan(pNumber2, pNumber1);
    }

    @Override
    protected Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return this.lessOrEquals(pNumber2, pNumber1);
    }

    @Override
    protected Long lessThan(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_lt(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_fp_leq(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long isNaN(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_isnan(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isInfinity(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_isinf(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isZero(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_iszero(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isSubnormal(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_issubnormal(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isNormal(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_isnormal(this.mathsatEnv, pParam);
    }

    @Override
    protected Long isNegative(Long pParam) {
        return Mathsat5NativeApi.msat_make_fp_isneg(this.mathsatEnv, pParam);
    }

    @Override
    protected Long round(Long pFormula, FloatingPointRoundingMode pRoundingMode) {
        return Mathsat5NativeApi.msat_make_fp_round_to_int(this.mathsatEnv, this.getRoundingModeImpl(pRoundingMode), pFormula);
    }
}

