/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

class Mathsat5ArrayFormulaManager
extends AbstractArrayFormulaManager<Long, Long, Long, Long> {
    private final long mathsatEnv;

    Mathsat5ArrayFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
        this.mathsatEnv = (Long)pCreator.getEnv();
    }

    @Override
    protected Long select(Long pArray, Long pIndex) {
        return Mathsat5NativeApi.msat_make_array_read(this.mathsatEnv, pArray, pIndex);
    }

    @Override
    protected Long store(Long pArray, Long pIndex, Long pValue) {
        return Mathsat5NativeApi.msat_make_array_write(this.mathsatEnv, pArray, pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Long internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        FormulaType.ArrayFormulaType<TI, TE> arrayFormulaType = FormulaType.getArrayType(pIndexType, pElementType);
        Long mathsatArrayType = (Long)this.toSolverType(arrayFormulaType);
        return (Long)this.getFormulaCreator().makeVariable(mathsatArrayType, pName);
    }

    @Override
    protected Long equivalence(Long pArray1, Long pArray2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pArray1, pArray2);
    }
}

