/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc5;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import io.github.cvc5.CVC5ApiException;
import io.github.cvc5.Kind;
import io.github.cvc5.Solver;
import io.github.cvc5.Sort;
import io.github.cvc5.Term;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc5.CVC5FormulaCreator;

public class CVC5BooleanFormulaManager
extends AbstractBooleanFormulaManager<Term, Sort, Solver, Term> {
    private final Solver solver;
    private final Term pTrue;
    private final Term pFalse;

    protected CVC5BooleanFormulaManager(CVC5FormulaCreator pCreator) {
        super(pCreator);
        this.solver = (Solver)pCreator.getEnv();
        this.pTrue = this.solver.mkBoolean(true);
        this.pFalse = this.solver.mkBoolean(false);
    }

    @Override
    @VisibleForTesting
    public Term makeVariableImpl(String pVar) {
        return (Term)this.formulaCreator.makeVariable((Sort)this.getFormulaCreator().getBoolType(), pVar);
    }

    @Override
    protected Term makeBooleanImpl(boolean pValue) {
        return pValue ? this.pTrue : this.pFalse;
    }

    @Override
    protected Term not(Term pParam1) {
        try {
            if (this.isTrue(pParam1)) {
                return this.pFalse;
            }
            if (this.isFalse(pParam1)) {
                return this.pTrue;
            }
            if (pParam1.getKind() == Kind.NOT) {
                return pParam1.getChild(0);
            }
        }
        catch (CVC5ApiException e) {
            throw new IllegalArgumentException("Failure when negating the term '" + pParam1 + "'.", e);
        }
        return this.solver.mkTerm(Kind.NOT, pParam1);
    }

    @Override
    protected Term and(Term pParam1, Term pParam2) {
        if (this.isTrue(pParam1)) {
            return pParam2;
        }
        if (this.isTrue(pParam2)) {
            return pParam1;
        }
        if (this.isFalse(pParam1)) {
            return this.pFalse;
        }
        if (this.isFalse(pParam2)) {
            return this.pFalse;
        }
        if (pParam1.equals((Object)pParam2)) {
            return pParam1;
        }
        return this.solver.mkTerm(Kind.AND, pParam1, pParam2);
    }

    @Override
    protected Term andImpl(Collection<Term> pParams) {
        LinkedHashSet<Term> operands = new LinkedHashSet<Term>();
        for (Term operand : pParams) {
            if (this.isFalse(operand)) {
                return this.pFalse;
            }
            if (this.isTrue(operand)) continue;
            operands.add(operand);
        }
        switch (operands.size()) {
            case 0: {
                return this.pTrue;
            }
            case 1: {
                return (Term)Iterables.getOnlyElement(operands);
            }
        }
        return this.solver.mkTerm(Kind.AND, operands.toArray(new Term[0]));
    }

    @Override
    protected Term or(Term pParam1, Term pParam2) {
        if (this.isTrue(pParam1)) {
            return this.pTrue;
        }
        if (this.isTrue(pParam2)) {
            return this.pTrue;
        }
        if (this.isFalse(pParam1)) {
            return pParam2;
        }
        if (this.isFalse(pParam2)) {
            return pParam1;
        }
        if (pParam1.equals((Object)pParam2)) {
            return pParam1;
        }
        return this.solver.mkTerm(Kind.OR, pParam1, pParam2);
    }

    @Override
    protected Term orImpl(Collection<Term> pParams) {
        LinkedHashSet<Term> operands = new LinkedHashSet<Term>();
        for (Term operand : pParams) {
            if (this.isTrue(operand)) {
                return this.pTrue;
            }
            if (this.isFalse(operand)) continue;
            operands.add(operand);
        }
        switch (operands.size()) {
            case 0: {
                return this.pFalse;
            }
            case 1: {
                return (Term)Iterables.getOnlyElement(operands);
            }
        }
        return this.solver.mkTerm(Kind.OR, operands.toArray(new Term[0]));
    }

    @Override
    protected Term xor(Term pParam1, Term pParam2) {
        return this.solver.mkTerm(Kind.XOR, pParam1, pParam2);
    }

    @Override
    protected Term equivalence(Term pBits1, Term pBits2) {
        return this.solver.mkTerm(Kind.EQUAL, pBits1, pBits2);
    }

    @Override
    protected Term implication(Term bits1, Term bits2) {
        return this.solver.mkTerm(Kind.IMPLIES, bits1, bits2);
    }

    @Override
    protected boolean isTrue(Term pBits) {
        return pBits.isBooleanValue() && pBits.getBooleanValue();
    }

    @Override
    protected boolean isFalse(Term pBits) {
        return pBits.isBooleanValue() && !pBits.getBooleanValue();
    }

    @Override
    protected Term ifThenElse(Term pCond, Term pF1, Term pF2) {
        if (this.isTrue(pCond)) {
            return pF1;
        }
        if (this.isFalse(pCond)) {
            return pF2;
        }
        if (pF1.equals((Object)pF2)) {
            return pF1;
        }
        if (this.isTrue(pF1) && this.isFalse(pF2)) {
            return pCond;
        }
        if (this.isFalse(pF1) && this.isTrue(pF2)) {
            return this.not(pCond);
        }
        return this.solver.mkTerm(Kind.ITE, pCond, pF1, pF2);
    }
}

