/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class AllSatExample {
    private static final ImmutableSet<SolverContextFactory.Solvers> SOLVERS_WITH_INTEGERS = ImmutableSet.of((Object)((Object)SolverContextFactory.Solvers.MATHSAT5), (Object)((Object)SolverContextFactory.Solvers.SMTINTERPOL), (Object)((Object)SolverContextFactory.Solvers.Z3), (Object)((Object)SolverContextFactory.Solvers.PRINCESS), (Object)((Object)SolverContextFactory.Solvers.CVC4), (Object)((Object)SolverContextFactory.Solvers.YICES2), (Object[])new SolverContextFactory.Solvers[0]);
    private static final ImmutableSet<SolverContextFactory.Solvers> SOLVERS_WITH_BITVECTORS = ImmutableSet.of((Object)((Object)SolverContextFactory.Solvers.MATHSAT5), (Object)((Object)SolverContextFactory.Solvers.Z3), (Object)((Object)SolverContextFactory.Solvers.PRINCESS), (Object)((Object)SolverContextFactory.Solvers.BOOLECTOR), (Object)((Object)SolverContextFactory.Solvers.CVC4));
    private BooleanFormulaManager bfmgr;
    private IntegerFormulaManager ifmgr;
    private BitvectorFormulaManager bvfmgr;
    private final ProverEnvironment prover;
    private final SolverContext context;

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        for (SolverContextFactory.Solvers solver : SolverContextFactory.Solvers.values()) {
            try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
                 ProverEnvironment prover = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS, SolverContext.ProverOptions.GENERATE_ALL_SAT);){
                logger.log(Level.WARNING, new Object[]{"Using solver " + solver + " in version " + context.getVersion()});
                AllSatExample ase = new AllSatExample(context, prover);
                prover.push();
                logger.log(Level.INFO, new Object[]{ase.allSatBooleans1()});
                prover.pop();
                prover.push();
                logger.log(Level.INFO, new Object[]{ase.allSatBooleans2()});
                prover.pop();
                if (SOLVERS_WITH_INTEGERS.contains((Object)solver)) {
                    prover.push();
                    logger.log(Level.INFO, new Object[]{ase.allSatIntegers()});
                    prover.pop();
                    prover.push();
                    logger.log(Level.INFO, new Object[]{ase.allSatIntegers2()});
                    prover.pop();
                }
                if (!SOLVERS_WITH_BITVECTORS.contains((Object)solver)) continue;
                prover.push();
                logger.log(Level.INFO, new Object[]{ase.allSatBitvectors()});
                prover.pop();
            }
            catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
                logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
            }
            catch (UnsupportedOperationException e) {
                logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
            }
        }
    }

    public AllSatExample(SolverContext pContext, ProverEnvironment pProver) {
        this.prover = pProver;
        this.context = pContext;
    }

    private List<List<BooleanFormula>> allSatBooleans1() throws InterruptedException, SolverException {
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        BooleanFormula p = this.bfmgr.makeVariable("p");
        BooleanFormula q = this.bfmgr.makeVariable("q");
        this.prover.addConstraint(this.bfmgr.implication(p, q));
        return this.prover.allSat(new BasicProverEnvironment.AllSatCallback<List<List<BooleanFormula>>>(){
            private final List<List<BooleanFormula>> models = new ArrayList<List<BooleanFormula>>();

            @Override
            public void apply(List<BooleanFormula> pModel) {
                this.models.add(pModel);
            }

            @Override
            public List<List<BooleanFormula>> getResult() {
                return this.models;
            }
        }, (List<BooleanFormula>)ImmutableList.of((Object)q, (Object)p));
    }

    private List<List<Model.ValueAssignment>> allSatBooleans2() throws InterruptedException, SolverException {
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        BooleanFormula p = this.bfmgr.makeVariable("p");
        BooleanFormula q = this.bfmgr.makeVariable("q");
        this.prover.addConstraint(this.bfmgr.implication(p, q));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        while (!this.prover.isUnsat()) {
            models.add((List<Model.ValueAssignment>)this.prover.getModelAssignments());
            Model model = this.prover.getModel();
            try {
                Boolean valueP;
                ArrayList<BooleanFormula> assignments = new ArrayList<BooleanFormula>();
                Boolean valueQ = model.evaluate(q);
                if (valueQ != null) {
                    assignments.add(this.bfmgr.equivalence(q, this.bfmgr.makeBoolean(valueQ)));
                }
                if ((valueP = model.evaluate(p)) != null) {
                    assignments.add(this.bfmgr.equivalence(p, this.bfmgr.makeBoolean(valueP)));
                }
                this.prover.addConstraint(this.bfmgr.not(this.bfmgr.and(assignments)));
            }
            finally {
                if (model == null) continue;
                model.close();
            }
        }
        return models;
    }

    private List<List<Model.ValueAssignment>> allSatIntegers() throws InterruptedException, SolverException {
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.ifmgr = this.context.getFormulaManager().getIntegerFormulaManager();
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("b");
        this.prover.addConstraint(this.ifmgr.lessOrEquals(this.num(1), a));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(a, this.num(10)));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(this.num(1), b));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(b, this.num(10)));
        this.prover.addConstraint(this.ifmgr.greaterOrEquals(a, (NumeralFormula.IntegerFormula)this.ifmgr.multiply(this.num(2), b)));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        while (!this.prover.isUnsat()) {
            models.add((List<Model.ValueAssignment>)this.prover.getModelAssignments());
            Model model = this.prover.getModel();
            try {
                BooleanFormula modelAsFormula = this.bfmgr.and(this.ifmgr.equal(a, this.num(model.evaluate(a))), this.ifmgr.equal(b, this.num(model.evaluate(b))));
                this.prover.addConstraint(this.bfmgr.not(modelAsFormula));
            }
            finally {
                if (model == null) continue;
                model.close();
            }
        }
        return models;
    }

    private List<List<Model.ValueAssignment>> allSatIntegers2() throws InterruptedException, SolverException {
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.ifmgr = this.context.getFormulaManager().getIntegerFormulaManager();
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("b");
        BooleanFormula p = this.bfmgr.makeVariable("p");
        BooleanFormula q = this.bfmgr.makeVariable("q");
        this.prover.addConstraint(this.ifmgr.lessOrEquals(this.num(1), a));
        this.prover.addConstraint(this.ifmgr.equal(this.num(0), b));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(a, this.num(3)));
        this.prover.addConstraint(this.bfmgr.equivalence(p, q));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        while (!this.prover.isUnsat()) {
            ImmutableList<Model.ValueAssignment> modelAssignments = this.prover.getModelAssignments();
            models.add((List<Model.ValueAssignment>)modelAssignments);
            ArrayList<BooleanFormula> modelAssignmentsAsFormulas = new ArrayList<BooleanFormula>();
            for (Model.ValueAssignment va : modelAssignments) {
                modelAssignmentsAsFormulas.add(va.getAssignmentAsFormula());
            }
            this.prover.addConstraint(this.bfmgr.not(this.bfmgr.and(modelAssignmentsAsFormulas)));
        }
        return models;
    }

    private NumeralFormula.IntegerFormula num(int number) {
        return (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(number);
    }

    private NumeralFormula.IntegerFormula num(BigInteger number) {
        return (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(number);
    }

    private List<List<Model.ValueAssignment>> allSatBitvectors() throws InterruptedException, SolverException {
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.bvfmgr = this.context.getFormulaManager().getBitvectorFormulaManager();
        int bitsize = 4;
        BitvectorFormula a = this.bvfmgr.makeVariable(4, "c");
        BitvectorFormula b = this.bvfmgr.makeVariable(4, "d");
        BooleanFormula p = this.bfmgr.makeVariable("r");
        BooleanFormula q = this.bfmgr.makeVariable("s");
        this.prover.addConstraint(this.bvfmgr.lessOrEquals(this.bv(4, 1), a, true));
        this.prover.addConstraint(this.bvfmgr.equal(this.bv(4, 0), b));
        this.prover.addConstraint(this.bvfmgr.lessOrEquals(a, this.bv(4, 3), true));
        this.prover.addConstraint(this.bfmgr.equivalence(p, q));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        while (!this.prover.isUnsat()) {
            ImmutableList<Model.ValueAssignment> modelAssignments = this.prover.getModelAssignments();
            models.add((List<Model.ValueAssignment>)modelAssignments);
            ArrayList<BooleanFormula> modelAssignmentsAsFormulas = new ArrayList<BooleanFormula>();
            for (Model.ValueAssignment va : modelAssignments) {
                modelAssignmentsAsFormulas.add(va.getAssignmentAsFormula());
            }
            this.prover.addConstraint(this.bfmgr.not(this.bfmgr.and(modelAssignmentsAsFormulas)));
        }
        return models;
    }

    private BitvectorFormula bv(int bitsize, int number) {
        return this.bvfmgr.makeBitvector(bitsize, number);
    }
}

