/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;

class StatisticsBitvectorFormulaManager
implements BitvectorFormulaManager {
    private final BitvectorFormulaManager delegate;
    private final SolverStatistics stats;

    StatisticsBitvectorFormulaManager(BitvectorFormulaManager pDelegate, SolverStatistics pStats) {
        this.delegate = (BitvectorFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
    }

    @Override
    public BitvectorFormula makeBitvector(int pLength, long pI) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.makeBitvector(pLength, pI);
    }

    @Override
    public BitvectorFormula makeBitvector(int pLength, BigInteger pI) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.makeBitvector(pLength, pI);
    }

    @Override
    public BitvectorFormula makeBitvector(int pLength, NumeralFormula.IntegerFormula pI) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.makeBitvector(pLength, pI);
    }

    @Override
    public NumeralFormula.IntegerFormula toIntegerFormula(BitvectorFormula pI, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.toIntegerFormula(pI, pSigned);
    }

    @Override
    public BitvectorFormula makeVariable(int pLength, String pVar) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.makeVariable(pLength, pVar);
    }

    @Override
    public BitvectorFormula makeVariable(FormulaType.BitvectorType pType, String pVar) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.makeVariable(pType, pVar);
    }

    @Override
    public int getLength(BitvectorFormula pNumber) {
        return this.delegate.getLength(pNumber);
    }

    @Override
    public BitvectorFormula negate(BitvectorFormula pNumber) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.negate(pNumber);
    }

    @Override
    public BitvectorFormula add(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.add(pNumber1, pNumber2);
    }

    @Override
    public BitvectorFormula subtract(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.subtract(pNumber1, pNumber2);
    }

    @Override
    public BitvectorFormula divide(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.divide(pNumber1, pNumber2, pSigned);
    }

    @Override
    public BitvectorFormula modulo(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.modulo(pNumber1, pNumber2, pSigned);
    }

    @Override
    public BitvectorFormula multiply(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.multiply(pNumber1, pNumber2);
    }

    @Override
    public BooleanFormula equal(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.equal(pNumber1, pNumber2);
    }

    @Override
    public BooleanFormula greaterThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.greaterThan(pNumber1, pNumber2, pSigned);
    }

    @Override
    public BooleanFormula greaterOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.greaterOrEquals(pNumber1, pNumber2, pSigned);
    }

    @Override
    public BooleanFormula lessThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.lessThan(pNumber1, pNumber2, pSigned);
    }

    @Override
    public BooleanFormula lessOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.lessOrEquals(pNumber1, pNumber2, pSigned);
    }

    @Override
    public BitvectorFormula not(BitvectorFormula pBits) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.not(pBits);
    }

    @Override
    public BitvectorFormula and(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.and(pBits1, pBits2);
    }

    @Override
    public BitvectorFormula or(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.or(pBits1, pBits2);
    }

    @Override
    public BitvectorFormula xor(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.xor(pBits1, pBits2);
    }

    @Override
    public BitvectorFormula shiftRight(BitvectorFormula pNumber, BitvectorFormula pToShift, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.shiftRight(pNumber, pToShift, pSigned);
    }

    @Override
    public BitvectorFormula shiftLeft(BitvectorFormula pNumber, BitvectorFormula pToShift) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.shiftLeft(pNumber, pToShift);
    }

    @Override
    public BitvectorFormula concat(BitvectorFormula pNumber, BitvectorFormula pAppend) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.concat(pNumber, pAppend);
    }

    @Override
    public BitvectorFormula extract(BitvectorFormula pNumber, int pMsb, int pLsb) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.extract(pNumber, pMsb, pLsb);
    }

    @Override
    public BitvectorFormula extend(BitvectorFormula pNumber, int pExtensionBits, boolean pSigned) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.extend(pNumber, pExtensionBits, pSigned);
    }

    @Override
    public BooleanFormula distinct(List<BitvectorFormula> pBits) {
        this.stats.bvOperations.getAndIncrement();
        return this.delegate.distinct(pBits);
    }
}

