/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;

public interface StringFormulaManager {
    public StringFormula makeString(String var1);

    public StringFormula makeVariable(String var1);

    public BooleanFormula equal(StringFormula var1, StringFormula var2);

    public BooleanFormula greaterThan(StringFormula var1, StringFormula var2);

    public BooleanFormula greaterOrEquals(StringFormula var1, StringFormula var2);

    public BooleanFormula lessThan(StringFormula var1, StringFormula var2);

    public BooleanFormula lessOrEquals(StringFormula var1, StringFormula var2);

    public BooleanFormula prefix(StringFormula var1, StringFormula var2);

    public BooleanFormula suffix(StringFormula var1, StringFormula var2);

    public BooleanFormula contains(StringFormula var1, StringFormula var2);

    public NumeralFormula.IntegerFormula indexOf(StringFormula var1, StringFormula var2, NumeralFormula.IntegerFormula var3);

    public StringFormula charAt(StringFormula var1, NumeralFormula.IntegerFormula var2);

    public StringFormula substring(StringFormula var1, NumeralFormula.IntegerFormula var2, NumeralFormula.IntegerFormula var3);

    public StringFormula replace(StringFormula var1, StringFormula var2, StringFormula var3);

    public StringFormula replaceAll(StringFormula var1, StringFormula var2, StringFormula var3);

    public NumeralFormula.IntegerFormula length(StringFormula var1);

    default public StringFormula concat(StringFormula ... parts) {
        return this.concat(Arrays.asList(parts));
    }

    public StringFormula concat(List<StringFormula> var1);

    public BooleanFormula in(StringFormula var1, RegexFormula var2);

    public RegexFormula makeRegex(String var1);

    public RegexFormula none();

    public RegexFormula all();

    public RegexFormula allChar();

    public RegexFormula range(StringFormula var1, StringFormula var2);

    default public RegexFormula range(char start, char end) {
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (String)"Range from start '%s' (%s) to end '%s' (%s) is empty.", (Object)Character.valueOf(start), (Object)start, (Object)Character.valueOf(end), (Object)end);
        return this.range(this.makeString(String.valueOf(start)), this.makeString(String.valueOf(end)));
    }

    default public RegexFormula concat(RegexFormula ... parts) {
        return this.concatRegex(Arrays.asList(parts));
    }

    public RegexFormula concatRegex(List<RegexFormula> var1);

    public RegexFormula union(RegexFormula var1, RegexFormula var2);

    public RegexFormula intersection(RegexFormula var1, RegexFormula var2);

    public RegexFormula complement(RegexFormula var1);

    public RegexFormula closure(RegexFormula var1);

    public RegexFormula difference(RegexFormula var1, RegexFormula var2);

    public RegexFormula cross(RegexFormula var1);

    public RegexFormula optional(RegexFormula var1);

    public RegexFormula times(RegexFormula var1, int var2);

    public NumeralFormula.IntegerFormula toIntegerFormula(StringFormula var1);

    public StringFormula toStringFormula(NumeralFormula.IntegerFormula var1);
}

