/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverException;

public interface InterpolatingProverEnvironment<T>
extends BasicProverEnvironment<T> {
    public BooleanFormula getInterpolant(Collection<T> var1) throws SolverException, InterruptedException;

    default public List<BooleanFormula> getSeqInterpolants(List<? extends Collection<T>> partitionedFormulas) throws SolverException, InterruptedException {
        return this.getTreeInterpolants(partitionedFormulas, new int[partitionedFormulas.size()]);
    }

    default public List<BooleanFormula> getSeqInterpolants0(List<T> formulas) throws SolverException, InterruptedException {
        return this.getSeqInterpolants(Lists.transform(formulas, ImmutableSet::of));
    }

    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<T>> var1, int[] var2) throws SolverException, InterruptedException;

    default public List<BooleanFormula> getTreeInterpolants0(List<T> formulas, int[] startOfSubTree) throws SolverException, InterruptedException {
        return this.getTreeInterpolants(Lists.transform(formulas, ImmutableSet::of), startOfSubTree);
    }

    public static boolean checkTreeStructure(int numOfPartitions, int[] startOfSubTree) {
        Preconditions.checkArgument((numOfPartitions > 0 ? 1 : 0) != 0, (Object)"at least one partition should be available.");
        Preconditions.checkArgument((numOfPartitions == startOfSubTree.length ? 1 : 0) != 0, (Object)"partitions and subtree table must have equal length.");
        for (int i = 0; i < numOfPartitions; ++i) {
            Preconditions.checkArgument((startOfSubTree[i] >= 0 ? 1 : 0) != 0, (Object)"tree contains negative node.");
            int j = i;
            while (startOfSubTree[i] < j) {
                j = startOfSubTree[j - 1];
            }
            Preconditions.checkArgument((startOfSubTree[i] == j ? 1 : 0) != 0, (Object)"invalid leaf of tree.");
        }
        Preconditions.checkArgument((startOfSubTree[numOfPartitions - 1] == 0 ? 1 : 0) != 0, (Object)"invalid root of tree.");
        return true;
    }
}

