/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import java.util.List;
import java.util.Set;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.EnumerationFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;

@Immutable
public abstract class FormulaType<T extends Formula> {
    public static final FormulaType<NumeralFormula.RationalFormula> RationalType = new NumeralType<NumeralFormula.RationalFormula>(){

        @Override
        public boolean isRationalType() {
            return true;
        }

        @Override
        public String toString() {
            return "Rational";
        }

        @Override
        public String toSMTLIBString() {
            return "Real";
        }
    };
    public static final FormulaType<NumeralFormula.IntegerFormula> IntegerType = new NumeralType<NumeralFormula.IntegerFormula>(){

        @Override
        public boolean isIntegerType() {
            return true;
        }

        @Override
        public String toString() {
            return "Integer";
        }

        @Override
        public String toSMTLIBString() {
            return "Int";
        }
    };
    public static final FormulaType<BooleanFormula> BooleanType = new FormulaType<BooleanFormula>(){

        @Override
        public boolean isBooleanType() {
            return true;
        }

        @Override
        public String toString() {
            return "Boolean";
        }

        @Override
        public String toSMTLIBString() {
            return "Bool";
        }
    };
    public static final FormulaType<FloatingPointRoundingModeFormula> FloatingPointRoundingModeType = new FloatingPointRoundingModeType();
    public static final FormulaType<StringFormula> StringType = new FormulaType<StringFormula>(){

        @Override
        public boolean isStringType() {
            return true;
        }

        @Override
        public String toString() {
            return "String";
        }

        @Override
        public String toSMTLIBString() {
            return "String";
        }
    };
    public static final FormulaType<RegexFormula> RegexType = new FormulaType<RegexFormula>(){

        @Override
        public boolean isRegexType() {
            return true;
        }

        @Override
        public String toString() {
            return "RegLan";
        }

        @Override
        public String toSMTLIBString() {
            return "RegLan";
        }
    };

    private FormulaType() {
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isBitvectorType() {
        return false;
    }

    public boolean isBooleanType() {
        return false;
    }

    public boolean isFloatingPointType() {
        return false;
    }

    public boolean isFloatingPointRoundingModeType() {
        return false;
    }

    public boolean isNumeralType() {
        return false;
    }

    public boolean isRationalType() {
        return false;
    }

    public boolean isIntegerType() {
        return false;
    }

    public boolean isSLType() {
        return false;
    }

    public boolean isStringType() {
        return false;
    }

    public boolean isRegexType() {
        return false;
    }

    public boolean isEnumerationType() {
        return false;
    }

    public abstract String toString();

    public abstract String toSMTLIBString();

    public static BitvectorType getBitvectorTypeWithSize(int size) {
        return new BitvectorType(size);
    }

    public static FloatingPointType getFloatingPointType(int exponentSize, int mantissaSize) {
        return new FloatingPointType(exponentSize, mantissaSize);
    }

    public static FloatingPointType getSinglePrecisionFloatingPointType() {
        return FloatingPointType.SINGLE_PRECISION_FP_TYPE;
    }

    public static FloatingPointType getDoublePrecisionFloatingPointType() {
        return FloatingPointType.DOUBLE_PRECISION_FP_TYPE;
    }

    public static <TD extends Formula, TR extends Formula> ArrayFormulaType<TD, TR> getArrayType(FormulaType<TD> pDomainSort, FormulaType<TR> pRangeSort) {
        return new ArrayFormulaType<TD, TR>(pDomainSort, pRangeSort);
    }

    public static EnumerationFormulaType getEnumerationType(String pName, Set<String> pElements) {
        return new EnumerationFormulaType(pName, pElements);
    }

    public static FormulaType<?> fromString(String t) {
        if (BooleanType.toString().equals(t)) {
            return BooleanType;
        }
        if (IntegerType.toString().equals(t)) {
            return IntegerType;
        }
        if (RationalType.toString().equals(t)) {
            return RationalType;
        }
        if (StringType.toString().equals(t)) {
            return StringType;
        }
        if (RegexType.toString().equals(t)) {
            return RegexType;
        }
        if (FloatingPointRoundingModeType.toString().equals(t)) {
            return FloatingPointRoundingModeType;
        }
        if (t.startsWith("FloatingPoint<")) {
            List exman = Splitter.on((char)',').limit(2).splitToList((CharSequence)t.substring(14, t.length() - 1));
            return FormulaType.getFloatingPointType(Integer.parseInt(((String)exman.get(0)).substring(4)), Integer.parseInt(((String)exman.get(1)).substring(5)));
        }
        if (t.startsWith("Bitvector<")) {
            return FormulaType.getBitvectorTypeWithSize(Integer.parseInt(t.substring(10, t.length() - 1)));
        }
        if (t.matches(".*\\(.*\\)")) {
            String name = t.substring(0, t.indexOf("(") - 1);
            String elementsStr = t.substring(t.indexOf("(") + 1, t.length() - 1);
            ImmutableSet elements = ImmutableSet.copyOf((Iterable)Splitter.on((String)", ").split((CharSequence)elementsStr));
            return new EnumerationFormulaType(name, (Set<String>)elements);
        }
        throw new AssertionError((Object)("unknown type:" + t));
    }

    @Immutable
    public static final class BitvectorType
    extends FormulaType<BitvectorFormula> {
        private final int size;

        private BitvectorType(int size) {
            this.size = size;
        }

        @Override
        public boolean isBitvectorType() {
            return true;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public String toString() {
            return "Bitvector<" + this.getSize() + ">";
        }

        public boolean equals(Object pObj) {
            if (pObj == this) {
                return true;
            }
            if (!(pObj instanceof BitvectorType)) {
                return false;
            }
            BitvectorType other = (BitvectorType)pObj;
            return this.size == other.size;
        }

        public int hashCode() {
            return this.size;
        }

        @Override
        public String toSMTLIBString() {
            return "(_ BitVec " + this.size + ")";
        }
    }

    @Immutable
    public static final class FloatingPointType
    extends FormulaType<FloatingPointFormula> {
        private static final FloatingPointType SINGLE_PRECISION_FP_TYPE = new FloatingPointType(8, 23);
        private static final FloatingPointType DOUBLE_PRECISION_FP_TYPE = new FloatingPointType(11, 52);
        private final int exponentSize;
        private final int mantissaSize;

        private FloatingPointType(int pExponentSize, int pMantissaSize) {
            this.exponentSize = pExponentSize;
            this.mantissaSize = pMantissaSize;
        }

        @Override
        public boolean isFloatingPointType() {
            return true;
        }

        public int getExponentSize() {
            return this.exponentSize;
        }

        public int getMantissaSize() {
            return this.mantissaSize;
        }

        public int getTotalSize() {
            return this.exponentSize + this.mantissaSize + 1;
        }

        public int hashCode() {
            return (31 + this.exponentSize) * 31 + this.mantissaSize;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatingPointType)) {
                return false;
            }
            FloatingPointType other = (FloatingPointType)obj;
            return this.exponentSize == other.exponentSize && this.mantissaSize == other.mantissaSize;
        }

        @Override
        public String toString() {
            return "FloatingPoint<exp=" + this.exponentSize + ",mant=" + this.mantissaSize + ">";
        }

        @Override
        public String toSMTLIBString() {
            return "(_ FloatingPoint " + this.exponentSize + " " + this.mantissaSize + ")";
        }
    }

    public static final class ArrayFormulaType<TI extends Formula, TE extends Formula>
    extends FormulaType<ArrayFormula<TI, TE>> {
        private final FormulaType<TE> elementType;
        private final FormulaType<TI> indexType;

        private ArrayFormulaType(FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            this.indexType = (FormulaType)Preconditions.checkNotNull(pIndexType);
            this.elementType = (FormulaType)Preconditions.checkNotNull(pElementType);
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        @Override
        public boolean isArrayType() {
            return true;
        }

        @Override
        public String toString() {
            return String.format("Array<%s,%s>", this.indexType, this.elementType);
        }

        public int hashCode() {
            return 31 * this.elementType.hashCode() + this.indexType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArrayFormulaType)) {
                return false;
            }
            ArrayFormulaType other = (ArrayFormulaType)obj;
            return this.elementType.equals(other.elementType) && this.indexType.equals(other.indexType);
        }

        @Override
        public String toSMTLIBString() {
            return "(Array " + this.indexType.toSMTLIBString() + " " + this.elementType.toSMTLIBString() + ")";
        }
    }

    public static final class EnumerationFormulaType
    extends FormulaType<EnumerationFormula> {
        private final String name;
        private final ImmutableSet<String> elements;

        private EnumerationFormulaType(String pName, Set<String> pElements) {
            this.name = (String)Preconditions.checkNotNull((Object)pName);
            this.elements = ImmutableSet.copyOf(pElements);
        }

        public String getName() {
            return this.name;
        }

        public ImmutableSet<String> getElements() {
            return this.elements;
        }

        public int getCardinality() {
            return this.elements.size();
        }

        @Override
        public boolean isEnumerationType() {
            return true;
        }

        @Override
        public String toString() {
            return String.format("%s (%s)", this.name, Joiner.on((String)", ").join(this.elements));
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.elements.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EnumerationFormulaType)) {
                return false;
            }
            EnumerationFormulaType other = (EnumerationFormulaType)obj;
            return this.name.equals(other.name) && this.elements.equals(other.elements);
        }

        @Override
        public String toSMTLIBString() {
            return "(" + this + ")";
        }
    }

    private static class FloatingPointRoundingModeType
    extends FormulaType<FloatingPointRoundingModeFormula> {
        private FloatingPointRoundingModeType() {
        }

        @Override
        public boolean isFloatingPointRoundingModeType() {
            return true;
        }

        @Override
        public String toString() {
            return "FloatingPointRoundingMode";
        }

        @Override
        public String toSMTLIBString() {
            throw new UnsupportedOperationException("rounding mode is not expected in symbol declarations");
        }
    }

    @Immutable
    public static abstract class NumeralType<T extends NumeralFormula>
    extends FormulaType<T> {
        @Override
        public final boolean isNumeralType() {
            return true;
        }
    }
}

