/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.time;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.time.Tickers;
import org.sosy_lab.common.time.TimeSpan;

public final class Timer {
    private static final String DEFAULT_CLOCK_PROPERTY_NAME;
    static final @Nullable Tickers.TickerWithUnit DEFAULT_CLOCK;
    final Tickers.TickerWithUnit clock;
    private volatile boolean running = false;
    private long startTime = 0L;
    private long sumTime = 0L;
    private long maxTime = 0L;
    private long minTime = Long.MAX_VALUE;
    private int numberOfIntervals = 0;
    private long lastIntervalLength = 0L;

    public Timer() {
        if (DEFAULT_CLOCK == null) {
            throw new IllegalArgumentException(String.format("Invalid value '%s' for property %s,cannot create Timer without explicitly specified clock.", System.getProperty(DEFAULT_CLOCK_PROPERTY_NAME), DEFAULT_CLOCK_PROPERTY_NAME));
        }
        this.clock = DEFAULT_CLOCK;
    }

    Timer(Tickers.TickerWithUnit pClock) {
        this.clock = (Tickers.TickerWithUnit)((Object)Preconditions.checkNotNull((Object)((Object)pClock)));
    }

    public void start() {
        this.start(this.clock.read());
    }

    void start(long newStartTime) {
        Preconditions.checkState((!this.running ? 1 : 0) != 0);
        this.startTime = newStartTime;
        ++this.numberOfIntervals;
        this.running = true;
    }

    public void stop() {
        this.stop(this.clock.read());
    }

    public void stopIfRunning() {
        if (this.isRunning()) {
            this.stop();
        }
    }

    void stop(long endTime) {
        Preconditions.checkState((boolean)this.running);
        this.lastIntervalLength = endTime - this.startTime;
        this.sumTime += this.lastIntervalLength;
        this.maxTime = Math.max(this.lastIntervalLength, this.maxTime);
        this.minTime = Math.min(this.lastIntervalLength, this.minTime);
        this.startTime = 0L;
        this.running = false;
    }

    TimeSpan export(long time) {
        return TimeSpan.of(time, this.clock.unit());
    }

    public boolean isRunning() {
        return this.running;
    }

    long currentInterval() {
        return this.running ? this.clock.read() - this.startTime : 0L;
    }

    public TimeSpan getSumTime() {
        return this.export(this.sumTime());
    }

    long sumTime() {
        return this.sumTime + this.currentInterval();
    }

    public TimeSpan getMaxTime() {
        return this.export(this.maxTime());
    }

    public TimeSpan getMinTime() {
        return this.export(this.minTime());
    }

    long maxTime() {
        return Math.max(this.maxTime, this.currentInterval());
    }

    long minTime() {
        if (this.minTime == Long.MAX_VALUE) {
            return 0L;
        }
        return this.minTime;
    }

    public int getNumberOfIntervals() {
        return this.numberOfIntervals;
    }

    public TimeSpan getLengthOfLastInterval() {
        return this.export(this.lengthOfLastInterval());
    }

    long lengthOfLastInterval() {
        return this.running ? this.currentInterval() : this.lastIntervalLength;
    }

    public TimeSpan getAvgTime() {
        int currentNumberOfIntervals = this.getNumberOfIntervals();
        if (currentNumberOfIntervals == 0) {
            return this.export(0L);
        }
        return this.export(this.sumTime() / (long)currentNumberOfIntervals);
    }

    public String toString() {
        return this.getSumTime().formatAs(TimeUnit.SECONDS);
    }

    public String prettyFormat() {
        TimeUnit t = TimeUnit.SECONDS;
        return String.format("%s (Max: %s), (Avg: %s), (#intervals = %s)", this.getSumTime().formatAs(t), this.getMaxTime().formatAs(t), this.getAvgTime().formatAs(t), this.getNumberOfIntervals());
    }

    static {
        String clockToUse;
        DEFAULT_CLOCK_PROPERTY_NAME = Timer.class.getCanonicalName() + ".timeSource";
        switch (clockToUse = Ascii.toUpperCase((String)System.getProperty(DEFAULT_CLOCK_PROPERTY_NAME, "WALLTIME_MILLIS").trim())) {
            case "WALLTIME_MILLIS": {
                DEFAULT_CLOCK = Tickers.getWalltimeMillis();
                break;
            }
            case "WALLTIME_NANOS": {
                DEFAULT_CLOCK = Tickers.getWalltimeNanos();
                break;
            }
            case "THREAD_CPUTIME": {
                DEFAULT_CLOCK = Tickers.getCurrentThreadCputime();
                break;
            }
            case "PROCESS_CPUTIME": {
                DEFAULT_CLOCK = Tickers.getProcessCputime();
                break;
            }
            case "NONE": {
                DEFAULT_CLOCK = Tickers.getNullTicker();
                break;
            }
            default: {
                DEFAULT_CLOCK = null;
            }
        }
    }
}

