/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.time;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;

public final class NestedTimer {
    private final Timer totalTimer = new Timer();
    private long innerSumTime = 0L;
    private volatile @Nullable Timer currentInnerTimer = null;
    private long innerMaxTime = 0L;
    private long outerMaxTime = 0L;
    private long lastOuterIntervalLength = 0L;

    public void startOuter() {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0);
        assert (this.currentInnerTimer == null);
        this.totalTimer.start();
        this.currentInnerTimer = new Timer(this.totalTimer.clock);
    }

    public void startBoth() {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0);
        assert (this.currentInnerTimer == null);
        long startTime = this.totalTimer.clock.read();
        this.totalTimer.start(startTime);
        this.currentInnerTimer = new Timer(this.totalTimer.clock);
        this.currentInnerTimer.start(startTime);
    }

    public void stopOuter() {
        Preconditions.checkState((boolean)this.isOnlyOuterRunning());
        this.stopOuter(this.totalTimer.clock.read());
    }

    private void stopOuter(long endTime) {
        assert (!this.currentInnerTimer.isRunning());
        this.totalTimer.stop(endTime);
        long currentInnerSumTime = this.currentInnerTimer.sumTime();
        this.lastOuterIntervalLength = this.totalTimer.lengthOfLastInterval() - currentInnerSumTime;
        this.outerMaxTime = Math.max(this.lastOuterIntervalLength, this.outerMaxTime);
        this.innerSumTime += currentInnerSumTime;
        this.innerMaxTime = Math.max(currentInnerSumTime, this.innerMaxTime);
        this.currentInnerTimer = null;
    }

    public void stopBoth() {
        Preconditions.checkState((boolean)this.isRunning());
        Preconditions.checkState((boolean)this.currentInnerTimer.isRunning());
        long endTime = this.totalTimer.clock.read();
        this.currentInnerTimer.stop(endTime);
        this.stopOuter(endTime);
    }

    public boolean isRunning() {
        return this.totalTimer.isRunning();
    }

    public boolean isOnlyOuterRunning() {
        return this.isRunning() && !this.currentInnerTimer.isRunning();
    }

    public Timer getCurentInnerTimer() {
        Preconditions.checkState((boolean)this.isRunning());
        return this.currentInnerTimer;
    }

    private long currentOuterInterval() {
        return this.isRunning() ? this.totalTimer.currentInterval() - this.currentInnerTimer.sumTime() : 0L;
    }

    public TimeSpan getOuterSumTime() {
        return this.totalTimer.export(this.outerSumTime());
    }

    private long outerSumTime() {
        return this.totalTimer.sumTime() - this.innerSumTime();
    }

    public TimeSpan getInnerSumTime() {
        return this.totalTimer.export(this.innerSumTime());
    }

    private long innerSumTime() {
        long result = this.innerSumTime;
        if (this.isRunning()) {
            result += this.currentInnerTimer.sumTime();
        }
        return result;
    }

    public TimeSpan getTotalSumTime() {
        return this.totalTimer.getSumTime();
    }

    public TimeSpan getOuterMaxTime() {
        return this.totalTimer.export(Math.max(this.outerMaxTime, this.currentOuterInterval()));
    }

    public TimeSpan getInnerMaxTime() {
        long result = this.innerMaxTime;
        if (this.isRunning()) {
            result = Math.max(result, this.currentInnerTimer.maxTime());
        }
        return this.totalTimer.export(result);
    }

    public TimeSpan getTotalMaxTime() {
        return this.totalTimer.getMaxTime();
    }

    public int getNumberOfIntervals() {
        return this.totalTimer.getNumberOfIntervals();
    }

    public TimeSpan getLengthOfLastOuterInterval() {
        return this.totalTimer.export(this.isRunning() ? this.currentOuterInterval() : this.lastOuterIntervalLength);
    }

    public TimeSpan getLengthOfLastTotalInterval() {
        return this.totalTimer.getLengthOfLastInterval();
    }

    public TimeSpan getOuterAvgTime() {
        int currentNumberOfIntervals = this.getNumberOfIntervals();
        if (currentNumberOfIntervals == 0) {
            return this.totalTimer.export(0L);
        }
        return this.totalTimer.export(this.outerSumTime() / (long)currentNumberOfIntervals);
    }

    public TimeSpan getInnerAvgSumTime() {
        int currentNumberOfIntervals = this.getNumberOfIntervals();
        if (currentNumberOfIntervals == 0) {
            return this.totalTimer.export(0L);
        }
        return this.totalTimer.export(this.innerSumTime() / (long)currentNumberOfIntervals);
    }

    public TimeSpan getTotalAvgTime() {
        return this.totalTimer.getAvgTime();
    }

    public String toString() {
        return this.getTotalSumTime().formatAs(TimeUnit.SECONDS);
    }
}

