/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.rationals;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.Var;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public final class Rational
extends Number
implements Comparable<Rational> {
    private static final long serialVersionUID = 1657347377738275521L;
    private static final BigInteger B_ZERO = BigInteger.ZERO;
    private static final BigInteger B_ONE = BigInteger.ONE;
    private static final BigInteger B_M_ONE = B_ONE.negate();
    public static final Rational ZERO = new Rational(B_ZERO, B_ONE);
    public static final Rational ONE = new Rational(B_ONE, B_ONE);
    public static final Rational NEG_ONE = new Rational(B_M_ONE, B_ONE);
    @LazyInit
    private transient @Nullable String stringCache = null;
    private final BigInteger num;
    private final BigInteger den;

    private Rational(BigInteger numerator, BigInteger denominator) {
        this.num = numerator;
        this.den = denominator;
        assert (this.den.signum() == 1);
    }

    public static Rational of(@Var BigInteger numerator, @Var BigInteger denominator) {
        Preconditions.checkNotNull((Object)numerator);
        int denSignum = denominator.signum();
        Preconditions.checkArgument((denSignum != 0 ? 1 : 0) != 0, (Object)"Infinity is not supported, use ExtendedRational instead");
        if (denSignum == -1) {
            denominator = denominator.negate();
            numerator = numerator.negate();
        }
        BigInteger gcd = numerator.gcd(denominator);
        numerator = numerator.divide(gcd);
        denominator = denominator.divide(gcd);
        return Rational.ofNormalForm(numerator, denominator);
    }

    private static Rational ofNormalForm(BigInteger num, BigInteger den) {
        if (num.equals(B_ZERO)) {
            return ZERO;
        }
        if (den.equals(B_ONE)) {
            if (num.equals(B_ONE)) {
                return ONE;
            }
            if (num.equals(B_M_ONE)) {
                return NEG_ONE;
            }
        }
        return new Rational(num, den);
    }

    public static Rational ofLongs(long numerator, long denominator) {
        return Rational.of(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational ofLong(long numerator) {
        return Rational.of(BigInteger.valueOf(numerator), B_ONE);
    }

    public static Rational ofBigInteger(BigInteger numerator) {
        return Rational.of(numerator, B_ONE);
    }

    public static Rational ofString(String s) {
        int idx = s.indexOf(47);
        if (idx == -1) {
            BigInteger num = new BigInteger(s);
            return Rational.ofBigInteger(num);
        }
        BigInteger num = new BigInteger(s.substring(0, idx));
        BigInteger den = new BigInteger(s.substring(idx + 1));
        return Rational.of(num, den);
    }

    public static Rational of(String s) {
        return Rational.ofString(s);
    }

    public static Rational of(long l) {
        return Rational.ofLong(l);
    }

    public static Rational ofBigDecimal(BigDecimal decimal) {
        if (decimal.scale() <= 0) {
            BigInteger num = decimal.toBigInteger();
            return Rational.of(num, BigInteger.ONE);
        }
        BigInteger num = decimal.unscaledValue();
        BigInteger denom = BigInteger.TEN.pow(decimal.scale());
        return Rational.of(num, denom);
    }

    public Rational times(Rational b) {
        Preconditions.checkNotNull((Object)b);
        Rational a = this;
        if (a == ZERO || b == ZERO) {
            return ZERO;
        }
        if (a == ONE) {
            return b;
        }
        if (b == ONE) {
            return a;
        }
        Rational c = Rational.of(a.num, b.den);
        Rational d = Rational.of(b.num, a.den);
        return Rational.ofNormalForm(c.num.multiply(d.num), c.den.multiply(d.den));
    }

    public Rational plus(Rational b) {
        Preconditions.checkNotNull((Object)b);
        Rational a = this;
        if (a == ZERO) {
            return b;
        }
        if (b == ZERO) {
            return a;
        }
        return Rational.of(a.num.multiply(b.den).add(b.num.multiply(a.den)), a.den.multiply(b.den));
    }

    public Rational minus(Rational b) {
        return this.plus(b.negate());
    }

    public Rational divides(Rational b) {
        return this.times(b.reciprocal());
    }

    public Rational reciprocal() {
        Preconditions.checkArgument((!this.num.equals(B_ZERO) ? 1 : 0) != 0, (Object)"Division by zero not supported, use ExtendedRational if you need it");
        return Rational.of(this.den, this.num);
    }

    public Rational negate() {
        return Rational.ofNormalForm(this.num.negate(), this.den);
    }

    @Override
    public double doubleValue() {
        return this.num.doubleValue() / this.den.doubleValue();
    }

    public boolean isIntegral() {
        return this.den.equals(B_ONE);
    }

    public BigInteger getNum() {
        return this.num;
    }

    public BigInteger getDen() {
        return this.den;
    }

    public int signum() {
        return this.num.signum();
    }

    public Rational abs() {
        return this.signum() == -1 ? this.negate() : this;
    }

    public String toString() {
        if (this.stringCache == null) {
            this.stringCache = this.den.equals(B_ONE) ? this.num.toString() : this.num + "/" + this.den;
        }
        return this.stringCache;
    }

    @Override
    public int compareTo(Rational b) {
        BigInteger lhs = this.num.multiply(b.den);
        BigInteger rhs = this.den.multiply(b.num);
        return lhs.subtract(rhs).signum();
    }

    public boolean equals(@Nullable Object y) {
        if (this == y) {
            return true;
        }
        if (y == null) {
            return false;
        }
        if (y.getClass() != this.getClass()) {
            return false;
        }
        Rational b = (Rational)y;
        return this.num.equals(b.num) && this.den.equals(b.den);
    }

    public int hashCode() {
        return Objects.hash(this.num, this.den);
    }

    public static Rational max(Rational a, Rational b) {
        if (a.compareTo(b) >= 0) {
            return a;
        }
        return b;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }
}

