/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.sosy_lab.common.log.AbstractColoredLogFormatter;
import org.sosy_lab.common.log.ExtendedLogRecord;
import org.sosy_lab.common.log.LogUtils;

public class TimestampedLogFormatter
extends AbstractColoredLogFormatter {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS").withLocale(Locale.getDefault(Locale.Category.FORMAT)).withZone(ZoneId.systemDefault());

    protected TimestampedLogFormatter(boolean useColors) {
        super(useColors);
    }

    @Override
    public void format(LogRecord lr, StringBuilder sb) {
        String component;
        DATE_FORMAT.formatTo(lr.getInstant(), sb);
        sb.append('\t').append(lr.getLevel()).append('\t');
        if (lr instanceof ExtendedLogRecord && !(component = ((ExtendedLogRecord)lr).getSourceComponentName()).isEmpty()) {
            sb.append(component).append(':');
        }
        sb.append(Objects.requireNonNullElse(LogUtils.extractSimpleClassName(lr), "$Unknown$")).append('.').append(Objects.requireNonNullElse(lr.getSourceMethodName(), "$unknown$")).append('\t').append(lr.getMessage()).append("\n\n");
    }

    public static Formatter withoutColors() {
        return new TimestampedLogFormatter(false);
    }

    public static Formatter withColorsIfPossible() {
        return new TimestampedLogFormatter(true);
    }
}

