/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StringBuildingLogHandler
extends Handler {
    @GuardedBy(value="this")
    private final StringBuilder sb = new StringBuilder();

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void publish(@Nullable LogRecord record) {
        String msg;
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            msg = this.getFormatter().format(record);
        }
        catch (RuntimeException ex) {
            this.reportError(null, ex, 5);
            return;
        }
        try {
            this.sb.append(msg);
        }
        catch (RuntimeException ex) {
            this.reportError(null, ex, 1);
        }
    }

    public synchronized String getLog() {
        return this.sb.toString();
    }

    public synchronized void clear() {
        this.sb.setLength(0);
        this.sb.trimToSize();
    }
}

