/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.FormatMethod;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.sosy_lab.common.log.ForwardingLogManager;
import org.sosy_lab.common.log.LogManager;

public class LogManagerWithoutDuplicates
extends ForwardingLogManager
implements LogManager {
    private final LogManager delegate;
    private final Set<ImmutableList<Object>> seenMessages = new HashSet<ImmutableList<Object>>();

    public LogManagerWithoutDuplicates(LogManager pDelegate) {
        this.delegate = (LogManager)Preconditions.checkNotNull((Object)pDelegate);
    }

    @Override
    protected LogManager delegate() {
        return this.delegate;
    }

    @Override
    public LogManagerWithoutDuplicates withComponentName(String pName) {
        return new LogManagerWithoutDuplicates(this.delegate.withComponentName(pName));
    }

    public void logOnce(Level pPriority, Object ... pArgs) {
        Preconditions.checkNotNull((Object)pArgs);
        if (this.wouldBeLogged(pPriority) && this.seenMessages.add((ImmutableList<Object>)ImmutableList.copyOf((Object[])pArgs))) {
            this.log(pPriority, pArgs);
        }
    }

    public void logOnce(Level pPriority, Supplier<String> pMsgSupplier) {
        String msg;
        Preconditions.checkNotNull(pMsgSupplier);
        if (this.wouldBeLogged(pPriority) && this.seenMessages.add((ImmutableList<Object>)ImmutableList.of((Object)(msg = pMsgSupplier.get())))) {
            this.log(pPriority, msg);
        }
    }

    @FormatMethod
    public void logfOnce(Level pPriority, String pFormat, Object ... pArgs) {
        Preconditions.checkNotNull((Object)pFormat);
        Preconditions.checkNotNull((Object)pArgs);
        if (this.wouldBeLogged(pPriority)) {
            ImmutableList.Builder args = ImmutableList.builder();
            args.add((Object)pFormat);
            args.add(pArgs);
            if (this.seenMessages.add((ImmutableList<Object>)args.build())) {
                this.logf(pPriority, pFormat, pArgs);
            }
        }
    }

    public void resetSeenMessages() {
        this.seenMessages.clear();
    }
}

