/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.MoreFiles;

public final class TempFile {
    private static final Path TMPDIR = Path.of(StandardSystemProperty.JAVA_IO_TMPDIR.value(), new String[0]);

    private TempFile() {
    }

    public static TempFileBuilder builder() {
        return new TempFileBuilder();
    }

    public static DeleteOnCloseDir createDeleteOnCloseDir(String pPrefix, FileAttribute<?> ... pFileAttributes) throws IOException {
        Path tempDir;
        Preconditions.checkNotNull((Object)pPrefix);
        try {
            tempDir = Files.createTempDirectory(TMPDIR, pPrefix, pFileAttributes);
        }
        catch (IOException e) {
            throw TempFile.improveIoExceptionMessage(e, TMPDIR, pPrefix + "*");
        }
        return new DeleteOnCloseDir(tempDir);
    }

    private static IOException improveIoExceptionMessage(IOException pException, Path pDir, String pPathString) {
        if (pException.getMessage() != null && pException.getMessage().contains(pDir.toString())) {
            return pException;
        }
        String fileName = pDir.resolve(pPathString).toString();
        if (Strings.nullToEmpty((String)pException.getMessage()).isEmpty()) {
            return new IOException(fileName, pException);
        }
        return new IOException(fileName + " (" + pException.getMessage() + ")", pException);
    }

    @Immutable
    public static final class DeleteOnCloseDir
    implements AutoCloseable {
        private final Path path;

        private DeleteOnCloseDir(Path pDir) {
            this.path = pDir;
        }

        public Path toPath() {
            return this.path;
        }

        @Override
        public void close() throws IOException {
            MoreFiles.deleteRecursively((Path)this.path, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
        }
    }

    @Immutable
    public static final class DeleteOnCloseFile
    extends MoreFiles.DeleteOnCloseFile
    implements AutoCloseable {
        private DeleteOnCloseFile(Path pFile) {
            super(pFile);
        }

        public ByteSource toByteSource() {
            return MoreFiles.asByteSource((Path)this.toPath(), (OpenOption[])new OpenOption[0]);
        }

        public ByteSink toByteSink() {
            return MoreFiles.asByteSink((Path)this.toPath(), (OpenOption[])new OpenOption[0]);
        }

        public CharSource toCharSource(Charset charset) {
            return MoreFiles.asCharSource((Path)this.toPath(), (Charset)charset, (OpenOption[])new OpenOption[0]);
        }

        public CharSink toCharSink(Charset charset) {
            return MoreFiles.asCharSink((Path)this.toPath(), (Charset)charset, (OpenOption[])new OpenOption[0]);
        }

        @Override
        public Path toPath() {
            return super.toPath();
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }

    public static final class TempFileBuilder {
        private Path dir = TMPDIR;
        private String suffix = ".tmp";
        private @Nullable String prefix;
        private @Nullable Object content;
        private @Nullable Charset charset;
        private boolean deleteOnJvmExit = true;
        private FileAttribute<?>[] fileAttributes = new FileAttribute[0];

        private TempFileBuilder() {
        }

        @CanIgnoreReturnValue
        public TempFileBuilder dir(Path pDir) {
            this.dir = (Path)Preconditions.checkNotNull((Object)pDir);
            return this;
        }

        @CanIgnoreReturnValue
        public TempFileBuilder prefix(String pPrefix) {
            this.prefix = (String)Preconditions.checkNotNull((Object)pPrefix);
            return this;
        }

        @CanIgnoreReturnValue
        public TempFileBuilder suffix(String pSuffix) {
            this.suffix = (String)Preconditions.checkNotNull((Object)pSuffix);
            return this;
        }

        @CanIgnoreReturnValue
        public TempFileBuilder initialContent(Object pContent, Charset pCharset) {
            Preconditions.checkNotNull((Object)pContent);
            Preconditions.checkNotNull((Object)pCharset);
            this.content = pContent;
            this.charset = pCharset;
            return this;
        }

        @CanIgnoreReturnValue
        public TempFileBuilder noDeleteOnJvmExit() {
            this.deleteOnJvmExit = false;
            return this;
        }

        @CanIgnoreReturnValue
        public TempFileBuilder fileAttributes(FileAttribute<?> ... pFileAttributes) {
            this.fileAttributes = (FileAttribute[])pFileAttributes.clone();
            return this;
        }

        public Path create() throws IOException {
            Path file;
            try {
                file = Files.createTempFile(this.dir, this.prefix, this.suffix, this.fileAttributes);
            }
            catch (IOException e) {
                throw TempFile.improveIoExceptionMessage(e, this.dir, this.prefix + "*" + this.suffix);
            }
            if (this.deleteOnJvmExit) {
                file.toFile().deleteOnExit();
            }
            if (this.content != null) {
                try {
                    IO.writeFile(file, this.charset, this.content);
                }
                catch (IOException e) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException deleteException) {
                        e.addSuppressed(deleteException);
                    }
                    throw e;
                }
            }
            return file;
        }

        public DeleteOnCloseFile createDeleteOnClose() throws IOException {
            return new DeleteOnCloseFile(this.create());
        }
    }
}

