/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.CharSource;
import com.google.common.io.MoreFiles;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import org.sosy_lab.common.Appenders;

public final class IO {
    private static final Charset NATIVE_CHARSET;

    private IO() {
    }

    public static Charset getNativeCharset() {
        return NATIVE_CHARSET;
    }

    public static StringBuilder toStringBuilder(CharSource source) throws IOException {
        StringBuilder sb = new StringBuilder();
        source.copyTo((Appendable)sb);
        return sb;
    }

    public static char[] toCharArray(CharSource source) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        source.copyTo((Appendable)writer);
        return writer.toCharArray();
    }

    public static void writeFile(Path file, Charset charset, Object content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        try (Writer w = IO.openOutputFile(file, charset, new OpenOption[0]);){
            Appenders.appendTo(w, content);
        }
    }

    public static void writeGZIPFile(Path file, Charset charset, Object content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)charset);
        MoreFiles.createParentDirectories((Path)file, (FileAttribute[])new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)gzipOutputStream, charset);
             BufferedWriter w = new BufferedWriter(outputStreamWriter);){
            Appenders.appendTo(w, content);
        }
    }

    public static Writer openOutputFile(Path file, Charset charset, OpenOption ... options) throws IOException {
        Preconditions.checkNotNull((Object)charset);
        Preconditions.checkNotNull((Object)options);
        MoreFiles.createParentDirectories((Path)file, (FileAttribute[])new FileAttribute[0]);
        return MoreFiles.asCharSink((Path)file, (Charset)charset, (OpenOption[])options).openBufferedStream();
    }

    public static void appendToFile(Path file, Charset charset, Object content) throws IOException {
        Preconditions.checkNotNull((Object)content);
        try (Writer w = IO.openOutputFile(file, charset, StandardOpenOption.APPEND);){
            Appenders.appendTo(w, content);
        }
    }

    public static void checkReadableFile(Path path) throws FileNotFoundException {
        Preconditions.checkNotNull((Object)path);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("File " + path.toAbsolutePath() + " does not exist!");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new FileNotFoundException("File " + path.toAbsolutePath() + " is not a normal file!");
        }
        if (!Files.isReadable(path)) {
            throw new FileNotFoundException("File " + path.toAbsolutePath() + " is not readable!");
        }
    }

    static {
        String nativeEncoding = System.getProperty("native.encoding");
        Charset charset = Charset.defaultCharset();
        if (nativeEncoding != null) {
            try {
                charset = Charset.forName(nativeEncoding);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
        NATIVE_CHARSET = charset;
    }
}

