/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.OutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DuplicateOutputStream
extends OutputStream {
    private final OutputStream stream1;
    private final OutputStream stream2;

    public DuplicateOutputStream(OutputStream pStream1, OutputStream pStream2) {
        this.stream1 = (OutputStream)Preconditions.checkNotNull((Object)pStream1);
        this.stream2 = (OutputStream)Preconditions.checkNotNull((Object)pStream2);
    }

    public static OutputStream mergeStreams(@Nullable OutputStream stream1, @Nullable OutputStream stream2) {
        if (stream1 == null) {
            if (stream2 == null) {
                return ByteStreams.nullOutputStream();
            }
            return stream2;
        }
        if (stream2 == null) {
            return stream1;
        }
        return new DuplicateOutputStream(stream1, stream2);
    }

    @Override
    public void write(int pB) throws IOException {
        try {
            this.stream1.write(pB);
        }
        finally {
            this.stream2.write(pB);
        }
    }

    @Override
    public void write(byte[] pB) throws IOException {
        try {
            this.stream1.write(pB);
        }
        finally {
            this.stream2.write(pB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] pB, int pOff, int pLen) throws IOException {
        try {
            this.stream1.write(pB, pOff, pLen);
        }
        finally {
            this.stream2.write(pB, pOff, pLen);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.stream1.flush();
        }
        finally {
            this.stream2.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream1.close();
        }
        finally {
            this.stream2.close();
        }
    }
}

