/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;

public class TimeSpanTypeConverter
implements TypeConverter {
    private static final ImmutableBiMap<String, TimeUnit> TIME_UNITS = ImmutableBiMap.of((Object)"ns", (Object)((Object)TimeUnit.NANOSECONDS), (Object)"ms", (Object)((Object)TimeUnit.MILLISECONDS), (Object)"s", (Object)((Object)TimeUnit.SECONDS), (Object)"min", (Object)((Object)TimeUnit.MINUTES), (Object)"h", (Object)((Object)TimeUnit.HOURS));
    private static final CharMatcher LETTER_MATCHER = CharMatcher.inRange((char)'a', (char)'z');

    @Override
    public Object convert(String optionName, String valueStr, TypeToken<?> pType, Annotation pOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        Comparable<Long> result;
        long rawValue;
        TimeUnit userUnit;
        int i;
        Class type = pType.getRawType();
        if (!(pOption instanceof TimeSpanOption)) {
            throw new UnsupportedOperationException("Time span options need to be annotated with @TimeSpanOption");
        }
        TimeSpanOption option = (TimeSpanOption)pOption;
        for (i = valueStr.length() - 1; i >= 0 && LETTER_MATCHER.matches(valueStr.charAt(i)); --i) {
        }
        if (i < 0) {
            throw new InvalidConfigurationException("Option " + optionName + " contains no number");
        }
        String userUnitStr = valueStr.substring(i + 1).trim();
        TimeUnit timeUnit = userUnit = userUnitStr.isEmpty() ? option.defaultUserUnit() : (TimeUnit)((Object)TIME_UNITS.get((Object)userUnitStr));
        if (userUnit == null) {
            throw new InvalidConfigurationException("Option " + optionName + " contains invalid unit");
        }
        try {
            rawValue = Long.parseLong(valueStr.substring(0, i + 1).trim());
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigurationException("Option " + optionName + " contains invalid number");
        }
        TimeUnit codeUnit = option.codeUnit();
        long value = codeUnit.convert(rawValue, userUnit);
        if (option.min() > value || value > option.max()) {
            String codeUnitStr = (String)TIME_UNITS.inverse().get((Object)codeUnit);
            throw new InvalidConfigurationException(String.format("Invalid value in configuration file: \"%s = %s (not in range [%d %s, %d %s])", optionName, value, option.min(), codeUnitStr, option.max(), codeUnitStr));
        }
        if (type.equals(Integer.class)) {
            if (value > Integer.MAX_VALUE) {
                throw new InvalidConfigurationException("Value for option " + optionName + " is larger than 2147483647");
            }
            result = (int)value;
        } else if (type.equals(Long.class)) {
            result = value;
        } else {
            assert (type.equals(TimeSpan.class));
            result = TimeSpan.of(rawValue, userUnit);
        }
        return result;
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, TypeToken<T> pType, Annotation pSecondaryOption) {
        return pValue;
    }
}

