/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.collect.Range;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.BaseTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.LogManager;

public class IntegerTypeConverter
implements TypeConverter {
    @Override
    public Object convert(String optionName, String valueStr, TypeToken<?> pType, Annotation pOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        Class type = pType.getRawType();
        if (!(pOption instanceof IntegerOption)) {
            throw new UnsupportedOperationException("IntegerTypeConverter needs options annotated with @IntegerOption");
        }
        IntegerOption option = (IntegerOption)pOption;
        assert (type.equals(Integer.class) || type.equals(Long.class));
        Object value = BaseTypeConverter.valueOf(type, optionName, valueStr);
        long n = ((Number)value).longValue();
        if (option.min() > n || n > option.max()) {
            Range bound = Range.closed((Comparable)Long.valueOf(option.min()), (Comparable)Long.valueOf(option.max()));
            Range typeBound = type.equals(Integer.class) ? Range.closed((Comparable)Long.valueOf(Integer.MIN_VALUE), (Comparable)Long.valueOf(Integer.MAX_VALUE)) : Range.all();
            throw new InvalidConfigurationException(String.format("Invalid value in configuration file: \"%s = %s\" (not in range %s).", optionName, value, bound.intersection(typeBound)));
        }
        return value;
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, TypeToken<T> pType, Annotation pSecondaryOption) {
        return pValue;
    }
}

