/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;

public enum BaseTypeConverter implements TypeConverter
{
    INSTANCE;


    @Override
    public Object convert(String optionName, String valueStr, TypeToken<?> pType, Annotation pSecondaryOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        Class type = pType.getRawType();
        if (Primitives.isWrapperType((Class)type)) {
            return BaseTypeConverter.valueOf(type, optionName, valueStr);
        }
        if (type.isEnum()) {
            try {
                return BaseTypeConverter.convertEnum(type, valueStr);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Invalid value " + valueStr + " for option " + optionName);
            }
        }
        if (type.equals(String.class)) {
            return valueStr;
        }
        if (type.equals(Charset.class)) {
            try {
                return Charset.forName(valueStr);
            }
            catch (IllegalCharsetNameException e) {
                throw new InvalidConfigurationException("Illegal charset '" + valueStr + "' in option " + optionName, e);
            }
            catch (UnsupportedCharsetException e) {
                throw new InvalidConfigurationException("Unsupported charset " + valueStr + " in option " + optionName, e);
            }
        }
        if (type.equals(Level.class)) {
            try {
                return Level.parse(valueStr);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Illegal log level " + valueStr + " in option " + optionName);
            }
        }
        if (type.equals(Pattern.class)) {
            try {
                return Pattern.compile(valueStr);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidConfigurationException(String.format("Illegal regular expression %s in option  %s (%s).", valueStr, optionName, e.getMessage()), e);
            }
        }
        if (type.equals(Rational.class)) {
            try {
                return Rational.of(valueStr);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException(String.format("Illegal rational %s in option  %s (%s).", valueStr, optionName, e.getMessage()), e);
            }
        }
        throw new UnsupportedOperationException("Unimplemented type for option: " + type.getSimpleName());
    }

    @Override
    public <T> T convertDefaultValue(String pOptionName, T pValue, TypeToken<T> pType, Annotation pSecondaryOption) throws InvalidConfigurationException {
        return pValue;
    }

    private static Object convertEnum(Class<?> cls, String value) {
        return Enum.valueOf(cls, value);
    }

    public static Object valueOf(Class<?> type, String optionName, String value) throws InvalidConfigurationException {
        return BaseTypeConverter.invokeStaticMethod(type, "valueOf", String.class, value, optionName);
    }

    public static <T> Object invokeStaticMethod(Class<?> type, String method, Class<T> paramType, T value, String optionName) throws InvalidConfigurationException {
        try {
            Method m = type.getMethod(method, paramType);
            m.setAccessible(true);
            return m.invoke(null, value);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError(String.format("Class %s without usable %s(%s) method.", type.getSimpleName(), method, paramType.getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new InvalidConfigurationException(String.format("Could not parse \"%s = %s\" (%s).", optionName, value, e.getTargetException().getMessage()), e);
        }
    }
}

