/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;

final class Parser {
    private static final Pattern OPTION_NAME = Pattern.compile("^[a-zA-Z0-9_+-]+(\\.[a-zA-Z0-9_+-]+)*((::required)?)$");
    private final Map<String, String> options = new HashMap<String, String>();
    private final Map<String, Path> sources = new HashMap<String, Path>();
    private final Deque<String> includeStack = new ArrayDeque<String>();

    private Parser() {
    }

    Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    Map<String, Path> getSources() {
        return Collections.unmodifiableMap(this.sources);
    }

    @CheckReturnValue
    static Parser parse(Path file) throws IOException, InvalidConfigurationException {
        Parser parser = new Parser();
        parser.parse0(file);
        Verify.verify((boolean)parser.includeStack.isEmpty());
        return parser;
    }

    private void parse0(Path file) throws IOException, InvalidConfigurationException {
        IO.checkReadableFile(file);
        String fileName = file.toAbsolutePath().toString();
        if (this.includeStack.contains(fileName)) {
            throw new InvalidConfigurationFileException("Circular inclusion of file " + file.toAbsolutePath());
        }
        this.includeStack.addLast(fileName);
        try (BufferedReader r = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            this.parse(r, Optional.of(file), file);
        }
        this.includeStack.removeLast();
    }

    @CheckReturnValue
    static Parser parse(CharSource source, Optional<Path> basePath, @Nullable Path sourcePath) throws IOException, InvalidConfigurationException {
        Parser parser = new Parser();
        try (BufferedReader r = source.openBufferedStream();){
            parser.parse(r, basePath, sourcePath);
        }
        Verify.verify((boolean)parser.includeStack.isEmpty());
        return parser;
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="performance irrelevant compared to I/O, String much more convenient")
    private void parse(BufferedReader r, Optional<Path> basePath, @Nullable Path source) throws IOException, InvalidConfigurationException {
        String line;
        Preconditions.checkNotNull(basePath);
        int lineno = 0;
        Object currentPrefix = "";
        String currentOptionName = null;
        Object currentValue = null;
        HashMap<CallSite, CallSite> definedOptions = new HashMap<CallSite, CallSite>();
        while ((line = r.readLine()) != null) {
            ++lineno;
            String fullLine = line = line.trim();
            assert (currentValue == null == (currentOptionName == null));
            if (currentValue != null) {
                currentValue = currentValue + line;
            } else {
                if (line.isEmpty() || line.equals("#") || line.startsWith("# ") || line.startsWith("//")) continue;
                if (line.startsWith("#")) {
                    if (!line.startsWith("#include")) {
                        throw new InvalidConfigurationFileException("Illegal parser directive", lineno, source, fullLine);
                    }
                    if ((line = line.substring("#include".length()).trim()).isEmpty()) {
                        throw new InvalidConfigurationFileException("Include without filename", lineno, source, fullLine);
                    }
                    Preconditions.checkArgument((boolean)basePath.isPresent(), (String)"File %s contains #include directive, but base path not given.", (Object)source);
                    this.parse0(basePath.orElseThrow().resolveSibling(line));
                    continue;
                }
                if (line.startsWith("[") && line.endsWith("]")) {
                    line = line.substring(1, line.length() - 1);
                    if ((line = line.trim()).isEmpty()) {
                        currentPrefix = "";
                        continue;
                    }
                    if (!OPTION_NAME.matcher(line).matches()) {
                        throw new InvalidConfigurationFileException("Invalid category \"" + line + "\"", lineno, source, fullLine);
                    }
                    currentPrefix = line + ".";
                    continue;
                }
                if (line.length() < 3) {
                    throw new InvalidConfigurationFileException("Illegal content", lineno, source, fullLine);
                }
                String[] bits = line.split("=", 2);
                if (bits.length != 2) {
                    throw new InvalidConfigurationFileException("Missing key-value separator", lineno, source, fullLine);
                }
                currentOptionName = bits[0].trim();
                if (!OPTION_NAME.matcher(currentOptionName).matches()) {
                    throw new InvalidConfigurationFileException("Invalid option \"" + currentOptionName + "\"", lineno, source, fullLine);
                }
                if (definedOptions.containsKey((String)currentPrefix + currentOptionName)) {
                    throw new InvalidConfigurationFileException("Duplicate option \"" + (String)currentPrefix + currentOptionName + "\"", lineno, source, fullLine);
                }
                currentValue = bits[1].trim();
            }
            assert (currentValue != null && currentOptionName != null);
            if (((String)currentValue).endsWith("\\")) {
                currentValue = ((String)currentValue).substring(0, ((String)currentValue).length() - 1);
                continue;
            }
            definedOptions.put((CallSite)((Object)((String)currentPrefix + currentOptionName)), (CallSite)currentValue);
            currentValue = null;
            currentOptionName = null;
        }
        assert (currentValue == null == (currentOptionName == null));
        if (currentValue != null) {
            definedOptions.put((CallSite)((Object)((String)currentPrefix + currentOptionName)), (CallSite)currentValue);
        }
        this.options.putAll(definedOptions);
        if (source != null) {
            this.sources.putAll(Maps.asMap(definedOptions.keySet(), (Function)Functions.constant((Object)source)));
        } else {
            this.sources.keySet().removeAll(definedOptions.keySet());
        }
    }

    static final class InvalidConfigurationFileException
    extends InvalidConfigurationException {
        private static final long serialVersionUID = 8146907093750189669L;

        private InvalidConfigurationFileException(String msg, int lineno, @Nullable Path source, String line) {
            super(msg + " in line " + lineno + (String)(source != null ? " of " + source : "") + ": " + line);
        }

        private InvalidConfigurationFileException(String msg) {
            super(msg);
        }
    }
}

