/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Parser;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.IO;

public final class ConfigurationBuilder {
    private @Nullable Map<String, String> properties = null;
    private @Nullable Map<String, Path> sources = null;
    private @Nullable Configuration oldConfig = null;
    private @Nullable String prefix = null;
    private @Nullable Map<Class<?>, TypeConverter> converters = null;

    ConfigurationBuilder() {
    }

    private void setupProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
            this.sources = new HashMap<String, Path>();
            if (this.oldConfig != null) {
                this.properties.putAll((Map<String, String>)this.oldConfig.properties);
                this.sources.putAll((Map<String, Path>)this.oldConfig.sources);
            }
        }
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder setOption(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        this.setupProperties();
        this.properties.put(name, value);
        this.sources.remove(name);
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder clearOption(String name) {
        Preconditions.checkNotNull((Object)name);
        this.setupProperties();
        this.properties.remove(name);
        this.sources.remove(name);
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder setOptions(Map<String, String> options) {
        Preconditions.checkNotNull(options);
        this.setupProperties();
        this.properties.putAll(options);
        this.sources.keySet().removeAll(options.keySet());
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder setPrefix(String newPrefix) {
        Preconditions.checkNotNull((Object)newPrefix);
        this.prefix = newPrefix;
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder copyFrom(Configuration sourceConfig) {
        Preconditions.checkNotNull((Object)sourceConfig);
        Preconditions.checkState((this.properties == null ? 1 : 0) != 0);
        Preconditions.checkState((this.sources == null ? 1 : 0) != 0);
        Preconditions.checkState((this.oldConfig == null ? 1 : 0) != 0);
        Preconditions.checkState((this.converters == null ? 1 : 0) != 0);
        this.oldConfig = sourceConfig;
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder copyOptionFrom(Configuration sourceConfig, String option) {
        Preconditions.checkNotNull((Object)sourceConfig);
        Preconditions.checkNotNull((Object)option);
        Preconditions.checkArgument((boolean)sourceConfig.properties.containsKey((Object)option));
        this.setupProperties();
        this.properties.put(option, (String)sourceConfig.properties.get((Object)option));
        if (sourceConfig.sources.containsKey((Object)option)) {
            this.sources.put(option, (Path)sourceConfig.sources.get((Object)option));
        } else {
            this.sources.remove(option);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder copyOptionFromIfPresent(Configuration sourceConfig, String option) {
        Preconditions.checkNotNull((Object)option);
        if (sourceConfig.properties.containsKey((Object)option)) {
            this.copyOptionFrom(sourceConfig, option);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder loadFromSource(CharSource source, String basePath, String sourceName) throws IOException, InvalidConfigurationException {
        Path sourcePath;
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)basePath);
        this.setupProperties();
        try {
            sourcePath = Path.of(sourceName, new String[0]);
        }
        catch (InvalidPathException e) {
            sourcePath = null;
        }
        Path base = Path.of(basePath, new String[0]).resolve("dummy");
        Parser parser = Parser.parse(source, Optional.of(base), sourcePath);
        this.properties.putAll(parser.getOptions());
        this.sources.putAll(parser.getSources());
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder loadFromFile(String filename) throws IOException, InvalidConfigurationException {
        return this.loadFromFile(Path.of(filename, new String[0]));
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder loadFromFile(Path file) throws IOException, InvalidConfigurationException {
        Preconditions.checkNotNull((Object)file);
        IO.checkReadableFile(file);
        this.setupProperties();
        Parser parser = Parser.parse(file);
        this.properties.putAll(parser.getOptions());
        this.sources.putAll(parser.getSources());
        return this;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder loadFromResource(Class<?> contextClass, String resourceName) {
        URL url = Resources.getResource(contextClass, (String)resourceName);
        CharSource source = Resources.asCharSource((URL)url, (Charset)StandardCharsets.UTF_8);
        this.setupProperties();
        try {
            URI uri = url.toURI();
            try (FileSystem fs = ConfigurationBuilder.getFileSystemForUriInJars(uri);){
                Path sourcePath = Path.of(uri);
                this.parseSource(contextClass, resourceName, source, Optional.of(sourcePath));
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | FileSystemNotFoundException e) {
            this.parseSource(contextClass, resourceName, source, Optional.empty());
        }
        return this;
    }

    private void parseSource(Class<?> contextClass, String resourceName, CharSource source, Optional<Path> sourcePath) {
        try {
            Parser parser = Parser.parse(source, sourcePath, sourcePath.orElse(null));
            this.properties.putAll(parser.getOptions());
            this.sources.putAll(parser.getSources());
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new IllegalArgumentException("Error in resource " + resourceName + " relative to " + contextClass.getName(), e);
        }
    }

    private static @Nullable FileSystem getFileSystemForUriInJars(URI uri) throws IOException {
        if (Objects.equals(uri.getScheme(), "jar")) {
            for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
                if (!provider.getScheme().equalsIgnoreCase("jar")) continue;
                try {
                    return provider.newFileSystem(uri, (Map<String, ?>)ImmutableMap.of());
                }
                catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
                }
            }
        }
        return null;
    }

    @CanIgnoreReturnValue
    public ConfigurationBuilder addConverter(Class<?> cls, TypeConverter converter) {
        Preconditions.checkNotNull(cls);
        Preconditions.checkNotNull((Object)converter);
        if (this.converters == null) {
            this.converters = Configuration.createConverterMap();
        }
        this.converters.put(cls, converter);
        return this;
    }

    @CheckReturnValue
    public Configuration build() throws InvalidConfigurationException {
        Set<String> newDeprecatedProperties;
        Set<String> newUnusedProperties;
        String newPrefix;
        Object newProperties = this.properties == null ? (this.oldConfig != null ? this.oldConfig.properties : ImmutableMap.of()) : ImmutableMap.copyOf(this.properties);
        Object newSources = this.sources == null ? (this.oldConfig != null ? this.oldConfig.sources : ImmutableMap.of()) : ImmutableMap.copyOf(this.sources);
        if (this.prefix == null) {
            if (this.oldConfig != null) {
                String tempPrefix = this.oldConfig.prefix;
                if (tempPrefix.length() > 1) {
                    assert (tempPrefix.charAt(tempPrefix.length() - 1) == '.');
                    tempPrefix = tempPrefix.substring(0, tempPrefix.length() - 1);
                }
                newPrefix = tempPrefix;
            } else {
                newPrefix = "";
            }
        } else {
            newPrefix = this.prefix;
        }
        if (this.oldConfig != null) {
            newUnusedProperties = this.oldConfig.unusedProperties;
            newDeprecatedProperties = this.oldConfig.deprecatedProperties;
        } else {
            newUnusedProperties = new HashSet<String>((Collection<String>)newProperties.keySet());
            newDeprecatedProperties = new HashSet<String>(0);
        }
        ImmutableMap<Class<?>, TypeConverter> newConverters = this.buildNewConverters((ImmutableMap<String, String>)newProperties, (ImmutableMap<String, Path>)newSources, newPrefix, newUnusedProperties, newDeprecatedProperties);
        Configuration newConfig = new Configuration((ImmutableMap<String, String>)newProperties, (ImmutableMap<String, Path>)newSources, newPrefix, newConverters, newUnusedProperties, newDeprecatedProperties, this.oldConfig != null ? this.oldConfig.getUsedOptionsPrintStream() : null, this.oldConfig != null ? this.oldConfig.getLogger() : null);
        this.properties = null;
        this.prefix = null;
        this.oldConfig = null;
        return newConfig;
    }

    private ImmutableMap<Class<?>, TypeConverter> buildNewConverters(ImmutableMap<String, String> newProperties, ImmutableMap<String, Path> newSources, String newPrefix, Set<String> newUnusedProperties, Set<String> newDeprecatedProperties) throws InvalidConfigurationException {
        Map<Class<?>, TypeConverter> oldConverters = this.oldConfig != null ? this.oldConfig.converters : Configuration.DEFAULT_CONVERTERS;
        Map<Class<?>, TypeConverter> newConverters = Configuration.createConverterMap();
        newConverters.putAll(oldConverters);
        if (this.converters != null) {
            newConverters.putAll(this.converters);
        }
        Configuration tempConfig = new Configuration(newProperties, newSources, newPrefix, ImmutableMap.copyOf(newConverters), newUnusedProperties, newDeprecatedProperties, this.oldConfig != null ? this.oldConfig.getUsedOptionsPrintStream() : null, this.oldConfig != null ? this.oldConfig.getLogger() : null);
        IdentityHashMap<TypeConverter, TypeConverter> adjustedConverters = new IdentityHashMap<TypeConverter, TypeConverter>(oldConverters.size());
        for (Map.Entry<Class<?>, TypeConverter> oldConverter : oldConverters.entrySet()) {
            if (this.converters != null && this.converters.containsKey(oldConverter.getKey())) continue;
            assert (newConverters.get(oldConverter.getKey()) == oldConverter.getValue());
            if (!adjustedConverters.containsKey(oldConverter.getValue())) {
                TypeConverter adjustedConverter = oldConverter.getValue().getInstanceForNewConfiguration(tempConfig);
                adjustedConverters.put(oldConverter.getValue(), adjustedConverter);
            }
            newConverters.put(oldConverter.getKey(), (TypeConverter)adjustedConverters.get(oldConverter.getValue()));
        }
        return ImmutableMap.copyOf(newConverters);
    }
}

