/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.sosy_lab.common.collect.NaiveOrderStatisticMap;
import org.sosy_lab.common.collect.OrderStatisticSet;

public interface OrderStatisticMap<K, V>
extends NavigableMap<K, V> {
    default public K getKeyByRank(int pIndex) {
        return this.getEntryByRank(pIndex).getKey();
    }

    public Map.Entry<K, V> getEntryByRank(int var1);

    @CanIgnoreReturnValue
    public K removeByRank(int var1);

    public int rankOf(K var1);

    @Override
    public OrderStatisticMap<K, V> descendingMap();

    @Override
    public OrderStatisticSet<K> navigableKeySet();

    @Override
    public OrderStatisticSet<K> descendingKeySet();

    @Override
    public OrderStatisticMap<K, V> subMap(K var1, boolean var2, K var3, boolean var4);

    @Override
    public OrderStatisticMap<K, V> headMap(K var1, boolean var2);

    @Override
    public OrderStatisticMap<K, V> tailMap(K var1, boolean var2);

    @Override
    public OrderStatisticMap<K, V> subMap(K var1, K var2);

    @Override
    public OrderStatisticMap<K, V> headMap(K var1);

    @Override
    public OrderStatisticMap<K, V> tailMap(K var1);

    public static <K, V> OrderStatisticMap<K, V> create() {
        return NaiveOrderStatisticMap.createMap();
    }

    public static <K, V> OrderStatisticMap<K, V> create(Comparator<? super K> pComparator) {
        return NaiveOrderStatisticMap.createMap(pComparator);
    }

    public static <K, V> OrderStatisticMap<K, V> createWithNaturalOrder(Map<? extends K, ? extends V> pMap) {
        return NaiveOrderStatisticMap.createMapWithNaturalOrder(pMap);
    }

    public static <K, V> OrderStatisticMap<K, V> createWithSameOrder(SortedMap<K, ? extends V> pSortedMap) {
        return NaiveOrderStatisticMap.createMapWithSameOrder(pSortedMap);
    }
}

