/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import org.sosy_lab.common.collect.OrderStatisticSet;

final class NaiveOrderStatisticSet<E>
extends ForwardingNavigableSet<E>
implements OrderStatisticSet<E>,
Serializable {
    private static final long serialVersionUID = -1941093176613766876L;
    private final NavigableSet<E> delegate;

    private NaiveOrderStatisticSet(NavigableSet<E> pDelegate) {
        this.delegate = pDelegate;
    }

    static <E> NaiveOrderStatisticSet<E> createSet() {
        return new NaiveOrderStatisticSet(new TreeSet());
    }

    static <E> NaiveOrderStatisticSet<E> createSet(Comparator<? super E> pComparator) {
        return new NaiveOrderStatisticSet(new TreeSet((Comparator)Preconditions.checkNotNull(pComparator)));
    }

    static <E> NaiveOrderStatisticSet<E> createSetWithNaturalOrder(Iterable<E> pSet) {
        TreeSet delegate = new TreeSet();
        Iterables.addAll(delegate, pSet);
        return new NaiveOrderStatisticSet(delegate);
    }

    static <E> NaiveOrderStatisticSet<E> createSetWithSameOrder(SortedSet<E> pSortedSet) {
        return new NaiveOrderStatisticSet(new TreeSet((SortedSet)Preconditions.checkNotNull(pSortedSet)));
    }

    static <E> NaiveOrderStatisticSet<E> createView(NavigableSet<E> pNavigableSet) {
        return new NaiveOrderStatisticSet<E>((NavigableSet)Preconditions.checkNotNull(pNavigableSet));
    }

    protected NavigableSet<E> delegate() {
        return this.delegate;
    }

    @Override
    public E getByRank(int pIndex) {
        return (E)Iterables.get(this.delegate, (int)pIndex);
    }

    @Override
    @CanIgnoreReturnValue
    public E removeByRank(int pIndex) {
        E elem = this.getByRank(pIndex);
        Preconditions.checkState((boolean)this.delegate.remove(elem), (Object)"Element could be retrieved, but not deleted");
        return elem;
    }

    @Override
    public int rankOf(E pObj) {
        Preconditions.checkNotNull(pObj);
        return Iterables.indexOf(this.delegate, o -> this.compare(o, pObj) == 0);
    }

    private int compare(E pO1, E pO2) {
        Comparator comparator = this.comparator();
        if (comparator != null) {
            return comparator.compare(pO1, pO2);
        }
        return ((Comparable)pO1).compareTo(pO2);
    }

    @Override
    public OrderStatisticSet<E> descendingSet() {
        return new NaiveOrderStatisticSet<E>(super.descendingSet());
    }

    @Override
    public OrderStatisticSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new NaiveOrderStatisticSet<E>(super.subSet(fromElement, fromInclusive, toElement, toInclusive));
    }

    @Override
    public OrderStatisticSet<E> headSet(E toElement, boolean inclusive) {
        return new NaiveOrderStatisticSet<E>(super.headSet(toElement, inclusive));
    }

    @Override
    public OrderStatisticSet<E> tailSet(E fromElement, boolean inclusive) {
        return new NaiveOrderStatisticSet<E>(super.tailSet(fromElement, inclusive));
    }

    @Override
    public OrderStatisticSet<E> headSet(E toElement) {
        return this.headSet((Object)toElement, false);
    }

    @Override
    public OrderStatisticSet<E> subSet(E fromElement, E toElement) {
        return this.subSet((Object)fromElement, true, (Object)toElement, false);
    }

    @Override
    public OrderStatisticSet<E> tailSet(E fromElement) {
        return this.tailSet((Object)fromElement, true);
    }
}

