/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.function.Supplier;

public final class MoreStrings {
    private MoreStrings() {
    }

    public static boolean startsWithIgnoreCase(@Var String s, String prefix) {
        int prefixLength = prefix.length();
        if (prefixLength > s.length()) {
            return false;
        }
        s = s.substring(0, prefixLength);
        return s.equalsIgnoreCase(prefix);
    }

    @CheckReturnValue
    public static Object lazyString(final Supplier<String> stringSupplier) {
        Preconditions.checkNotNull(stringSupplier);
        return new Object(){

            public String toString() {
                return (String)Preconditions.checkNotNull((Object)((String)stringSupplier.get()));
            }
        };
    }

    @CheckReturnValue
    public static Object longStringOf(final WithLongString obj) {
        Preconditions.checkNotNull((Object)obj);
        return new Object(){

            public String toString() {
                return (String)Preconditions.checkNotNull((Object)obj.toLongString());
            }
        };
    }

    public static interface WithLongString {
        @CheckReturnValue
        public String toLongString();
    }
}

