/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import org.sosy_lab.common.AutoValue_ExtendedURLClassLoader_ExtendedURLClassLoaderConfiguration;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.NativeLibraries;

final class ExtendedURLClassLoader
extends URLClassLoader {
    private final ExtendedURLClassLoaderConfiguration config;

    private ExtendedURLClassLoader(ExtendedURLClassLoaderConfiguration pConfig) {
        super((URL[])pConfig.urls().toArray((Object[])new URL[0]), pConfig.parent().orElseGet(ClassLoader::getSystemClassLoader));
        this.config = pConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean pResolve) throws ClassNotFoundException {
        if (!this.config.directLoadClasses().test(name)) {
            return super.loadClass(name, pResolve);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (pResolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    protected String findLibrary(String libname) {
        Optional<Path> path;
        Preconditions.checkNotNull((Object)libname);
        if (this.config.customLookupNativeLibraries().test(libname) && (path = NativeLibraries.findPathForLibrary(libname)).isPresent()) {
            return path.orElseThrow().toAbsolutePath().toString();
        }
        return super.findLibrary(libname);
    }

    @AutoValue
    static abstract class ExtendedURLClassLoaderConfiguration {
        ExtendedURLClassLoaderConfiguration() {
        }

        abstract Optional<ClassLoader> parent();

        abstract ImmutableList<URL> urls();

        abstract Predicate<String> directLoadClasses();

        abstract Predicate<String> customLookupNativeLibraries();

        static AutoBuilder builder() {
            return new AutoValue_ExtendedURLClassLoader_ExtendedURLClassLoaderConfiguration.Builder();
        }

        @AutoValue.Builder
        static abstract class AutoBuilder
        extends Classes.ClassLoaderBuilder<AutoBuilder> {
            AutoBuilder() {
            }

            @Override
            @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
            public final URLClassLoader build() {
                return new ExtendedURLClassLoader(this.autoBuild());
            }
        }
    }
}

