/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class Concurrency {
    private Concurrency() {
    }

    public static void waitForTermination(ExecutorService executor) {
        boolean interrupted = Thread.interrupted();
        while (!executor.isTerminated()) {
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException ignored) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static ExecutorService createThreadPool() {
        int processors = Runtime.getRuntime().availableProcessors();
        return Executors.newFixedThreadPool(processors);
    }

    public static ExecutorService createThreadPool(ThreadFactory threadFactory) {
        int processors = Runtime.getRuntime().availableProcessors();
        return Executors.newFixedThreadPool(processors, threadFactory);
    }

    public static Thread newThread(String name, Runnable r) {
        Preconditions.checkNotNull((Object)r);
        return new ThreadFactoryBuilder().setNameFormat(name).build().newThread(r);
    }

    public static Thread newDaemonThread(String name, Runnable r) {
        Preconditions.checkNotNull((Object)r);
        return new ThreadFactoryBuilder().setNameFormat(name).setDaemon(true).build().newThread(r);
    }
}

