/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import qilin.util.graph.Tree;
import qilin.util.graph.TreeNode;

public class TreeImpl<N>
implements Tree<N> {
    Map<N, TreeNode<N>> data2Node = new HashMap<N, TreeNode<N>>();
    TreeNode<N> root;

    @Override
    public N getRoot() {
        if (this.root == null) {
            for (TreeNode<N> n : this.data2Node.values()) {
                if (!n.isRoot()) continue;
                this.root = n;
                break;
            }
        }
        return this.root != null ? (N)this.root.getElem() : null;
    }

    @Override
    public Collection<N> getLeaves() {
        return this.getAllNodes().stream().filter(this::isALeaf).collect(Collectors.toSet());
    }

    @Override
    public boolean isALeaf(N o) {
        return this.data2Node.containsKey(o) && this.data2Node.get(o).isLeaf();
    }

    @Override
    public Collection<N> getAllNodes() {
        return this.data2Node.keySet();
    }

    public Collection<TreeNode<N>> getAllTreeNodes() {
        return this.data2Node.values();
    }

    @Override
    public int size() {
        return this.data2Node.size();
    }

    @Override
    public N parentOf(N o) {
        return this.data2Node.containsKey(o) ? (N)this.data2Node.get(o).getParent().getElem() : null;
    }

    @Override
    public Collection<N> childrenOf(N o) {
        if (this.data2Node.containsKey(o)) {
            TreeNode<N> node = this.data2Node.get(o);
            return node.getChildren().stream().map(TreeNode::getElem).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public boolean addTreeEdge(N parent, N child) {
        TreeNode p = this.data2Node.computeIfAbsent(parent, k -> new TreeNode<Object>(parent));
        TreeNode c = this.data2Node.computeIfAbsent(child, k -> new TreeNode<Object>(child));
        boolean f = p.addChild(c);
        c.setParent(p);
        return f;
    }
}

