/*
 * Decompiled with CFR 0.152.
 */
package qilin.util.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import qilin.util.graph.DirectedGraph;

public class StronglyConnectedComponents<N> {
    private final List<List<N>> componentList = new ArrayList<List<N>>();
    private final List<List<N>> trueComponentList = new ArrayList<List<N>>();
    private int index = 0;
    private Map<N, Integer> indexForNode;
    private Map<N, Integer> lowlinkForNode;
    private Stack<N> stack;
    private DirectedGraph<N> graph;

    public StronglyConnectedComponents(DirectedGraph<N> graph) {
        this.graph = graph;
        this.stack = new Stack();
        this.indexForNode = new HashMap<N, Integer>();
        this.lowlinkForNode = new HashMap<N, Integer>();
        for (N node : graph.allNodes()) {
            if (this.indexForNode.containsKey(node)) continue;
            this.recurse(node);
        }
        this.validate(graph, this.componentList);
        this.indexForNode = null;
        this.lowlinkForNode = null;
        this.stack = null;
        this.graph = null;
    }

    public List<List<N>> getComponents() {
        return this.componentList;
    }

    public List<List<N>> getTrueComponents() {
        return this.trueComponentList;
    }

    private void recurse(N node) {
        this.indexForNode.put(node, this.index);
        this.lowlinkForNode.put(node, this.index);
        ++this.index;
        this.stack.push(node);
        for (N succ : this.graph.succsOf(node)) {
            if (!this.indexForNode.containsKey(succ)) {
                this.recurse(succ);
                this.lowlinkForNode.put(node, Math.min(this.lowlinkForNode.get(node), this.lowlinkForNode.get(succ)));
                continue;
            }
            if (!this.stack.contains(succ)) continue;
            this.lowlinkForNode.put(node, Math.min(this.lowlinkForNode.get(node), this.indexForNode.get(succ)));
        }
        if (this.lowlinkForNode.get(node).intValue() == this.indexForNode.get(node).intValue()) {
            N v2;
            ArrayList<N> scc = new ArrayList<N>();
            do {
                v2 = this.stack.pop();
                scc.add(v2);
            } while (node != v2);
            this.componentList.add(scc);
            if (scc.size() > 1) {
                this.trueComponentList.add(scc);
            } else {
                Object n = scc.get(0);
                if (this.graph.succsOf(n).contains(n)) {
                    this.trueComponentList.add(scc);
                }
            }
        }
    }

    private void validate(DirectedGraph<N> graph, List<List<N>> SCCs) {
        assert (graph.allNodes().size() == SCCs.stream().mapToInt(List::size).sum());
    }
}

