/*
 * Decompiled with CFR 0.152.
 */
package qilin.util;

public class Stopwatch {
    private final String name;
    private long elapsedTime = 0L;
    private long startTime;
    private boolean inCounting = false;

    public static Stopwatch newAndStart(String name) {
        Stopwatch stopwatch = new Stopwatch(name);
        stopwatch.start();
        return stopwatch;
    }

    private Stopwatch(String name) {
        this.name = name;
    }

    private void start() {
        if (!this.inCounting) {
            this.inCounting = true;
            this.startTime = System.currentTimeMillis();
        }
    }

    public void stop() {
        if (this.inCounting) {
            this.elapsedTime += System.currentTimeMillis() - this.startTime;
            this.inCounting = false;
        }
    }

    public float elapsed() {
        return (float)this.elapsedTime / 1000.0f;
    }

    public void reset() {
        this.elapsedTime = 0L;
        this.inCounting = false;
    }

    public void restart() {
        this.reset();
        this.start();
    }

    public String toString() {
        return String.format("%s elapsed time: %.2fs", this.name, Float.valueOf(this.elapsed()));
    }
}

