/*
 * Decompiled with CFR 0.152.
 */
package qilin.stat;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.builder.FakeMainFactory;
import qilin.core.builder.callgraph.Edge;
import qilin.core.builder.callgraph.OnFlyCallGraph;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextMethod;
import qilin.stat.AbstractStat;
import qilin.stat.Exporter;
import qilin.util.PTAUtils;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.core.views.View;

public class TypeClientStat
implements AbstractStat {
    private final PTA pta;
    private int totalCasts = 0;
    private int appCasts = 0;
    private int totalCastsMayFail = 0;
    private int appCastsMayFail = 0;
    private int totalVirtualCalls = 0;
    private int appVirtualCalls = 0;
    private int totalPolyCalls = 0;
    private int appPolyCalls = 0;
    private int totalStaticCalls = 0;
    private int totalPolyCallTargets = 0;
    private int unreachable = 0;
    private final Map<AbstractInvokeExpr, SootMethod> polyCalls = new HashMap<AbstractInvokeExpr, SootMethod>();
    private final Map<SootMethod, Set<Stmt>> mayFailCasts = new HashMap<SootMethod, Set<Stmt>>();

    public TypeClientStat(PTA pta) {
        this.pta = pta;
        this.init();
    }

    private void init() {
        OnFlyCallGraph callGraph = this.pta.getCallGraph();
        HashSet<SootMethod> reachableMethods = new HashSet<SootMethod>();
        for (ContextMethod momc : this.pta.getCgb().getReachableMethods()) {
            SootMethod sm = momc.method();
            reachableMethods.add(sm);
        }
        for (SootMethod sm : reachableMethods) {
            View view = this.pta.getView();
            Optional osc = view.getClass(sm.getDeclaringClassType());
            if (!osc.isPresent()) continue;
            SootClass sc = (SootClass)osc.get();
            boolean app = sc.isApplicationClass();
            for (Stmt st : PTAUtils.getMethodBody(sm).getStmts()) {
                if (st.isInvokableStmt() && st.asInvokableStmt().containsInvokeExpr()) {
                    AbstractInvokeExpr ie = (AbstractInvokeExpr)st.asInvokableStmt().getInvokeExpr().get();
                    if (ie instanceof JStaticInvokeExpr) {
                        ++this.totalStaticCalls;
                        continue;
                    }
                    ++this.totalVirtualCalls;
                    if (app) {
                        ++this.appVirtualCalls;
                    }
                    HashSet<SootMethod> targets = new HashSet<SootMethod>();
                    Iterator<Edge> it = callGraph.edgesOutOf(st);
                    while (it.hasNext()) {
                        targets.add(it.next().tgt());
                    }
                    if (targets.size() == 0) {
                        ++this.unreachable;
                    }
                    if (targets.size() <= 1) continue;
                    this.totalPolyCallTargets += targets.size();
                    ++this.totalPolyCalls;
                    this.polyCalls.put(ie, sm);
                    if (!app) continue;
                    ++this.appPolyCalls;
                    continue;
                }
                if (!(st instanceof JAssignStmt)) continue;
                JAssignStmt assignStmt = (JAssignStmt)st;
                Value rhs = assignStmt.getRightOp();
                LValue lhs = assignStmt.getLeftOp();
                if (!(rhs instanceof JCastExpr) || !(lhs.getType() instanceof ReferenceType)) continue;
                Type targetType = rhs.getType();
                Immediate v = ((JCastExpr)rhs).getOp();
                if (!(v instanceof Local)) continue;
                ++this.totalCasts;
                if (app) {
                    ++this.appCasts;
                }
                boolean fails = false;
                Collection<AllocNode> pts = this.pta.reachingObjects(sm, (Local)v).toCollection();
                for (AllocNode n : pts) {
                    if (fails) break;
                    fails = !PTAUtils.castNeverFails(this.pta.getView(), n.getType(), targetType);
                }
                if (!fails) continue;
                ++this.totalCastsMayFail;
                this.mayFailCasts.computeIfAbsent(sm, k -> new HashSet()).add(st);
                if (!app) continue;
                ++this.appCastsMayFail;
            }
        }
    }

    @Override
    public void export(Exporter exporter) {
        exporter.collectMetric("#Cast (Total):", String.valueOf(this.totalCasts));
        exporter.collectMetric("#Cast (AppOnly):", String.valueOf(this.appCasts));
        exporter.collectMetric("#May Fail Cast (Total):", String.valueOf(this.totalCastsMayFail));
        exporter.collectMetric("#May Fail Cast (AppOnly):", String.valueOf(this.appCastsMayFail));
        exporter.collectMetric("#Static Call Site(Total):", String.valueOf(this.totalStaticCalls - FakeMainFactory.implicitCallEdges));
        exporter.collectMetric("#Virtual Call Site(Total):", String.valueOf(this.totalVirtualCalls));
        exporter.collectMetric("#Virtual Call Site(AppOnly):", String.valueOf(this.appVirtualCalls));
        exporter.collectMetric("#Virtual Call Site(Polymorphic):", String.valueOf(this.totalPolyCalls));
        exporter.collectMetric("#Virtual Call Site(Polymorphic AppOnly):", String.valueOf(this.appPolyCalls));
        exporter.collectMetric("#Virtual Call Site(Unreachable):", String.valueOf(this.unreachable));
        exporter.collectMetric("#Avg Poly Call Targets:", String.valueOf(1.0 * (double)this.totalPolyCallTargets / (double)this.totalPolyCalls));
        if (CoreConfig.v().getOutConfig().dumpStats) {
            exporter.dumpPolyCalls(this.polyCalls);
            exporter.dumpMayFailCasts(this.mayFailCasts);
        }
    }
}

