/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.zipper.flowgraph;

import java.util.Objects;
import qilin.core.pag.Node;
import qilin.pta.toolkits.zipper.flowgraph.Kind;

public class Edge {
    private final Kind kind;
    private final Node source;
    private final Node target;
    private final int hashCode;

    public Edge(Kind kind, Node source, Node target) {
        this.kind = kind;
        this.source = source;
        this.target = target;
        this.hashCode = Objects.hash(new Object[]{kind, source, target});
    }

    public Kind getKind() {
        return this.kind;
    }

    public Node getSource() {
        return this.source;
    }

    public Node getTarget() {
        return this.target;
    }

    public String toString() {
        return (Object)((Object)this.kind) + ": " + this.source + " --> " + this.target;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this.isOFGEdge()) {
            return this == other;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge otherEdge = (Edge)other;
        return this.kind.equals((Object)otherEdge.kind) && this.source.equals(otherEdge.source) && this.target.equals(otherEdge.target);
    }

    private boolean isOFGEdge() {
        return this.kind != Kind.WRAPPED_FLOW && this.kind != Kind.UNWRAPPED_FLOW;
    }
}

