/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.mahjong.automata;

import java.util.Collection;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import qilin.core.pag.SparkField;
import qilin.pta.toolkits.mahjong.automata.DFA;
import qilin.pta.toolkits.mahjong.automata.DFAState;
import qilin.util.Pair;
import qilin.util.UnionFindSet;
import sootup.core.types.Type;

public class DFAEquivalenceChecker {
    public boolean isEquivalent(DFA dfa1, DFA dfa2) {
        CombinedDFA dfa = new CombinedDFA(dfa1, dfa2);
        Set combinedStates = dfa.getStates();
        UnionFindSet<DFAState> uf = new UnionFindSet<DFAState>(combinedStates);
        Stack<Pair<DFAState, DFAState>> stack = new Stack<Pair<DFAState, DFAState>>();
        DFAState s1 = dfa1.getStartState();
        DFAState s2 = dfa2.getStartState();
        uf.union(s1, s2);
        stack.push(new Pair<DFAState, DFAState>(s1, s2));
        while (!stack.isEmpty()) {
            Pair pair = (Pair)stack.pop();
            DFAState q1 = (DFAState)pair.getFirst();
            DFAState q2 = (DFAState)pair.getSecond();
            Stream.concat(dfa.outEdgesOf(q1).stream(), dfa.outEdgesOf(q2).stream()).forEach(field -> {
                DFAState r2;
                DFAState r1 = uf.find(q1.nextState((SparkField)field));
                if (r1 != (r2 = uf.find(q2.nextState((SparkField)field)))) {
                    uf.union(r1, r2);
                    stack.push(new Pair<DFAState, DFAState>(r1, r2));
                }
            });
        }
        Collection<Set<DFAState>> mergedStateSets = uf.getDisjointSets();
        return this.validate(dfa, mergedStateSets);
    }

    private boolean validate(CombinedDFA dfa, Collection<Set<DFAState>> mergedStateSets) {
        for (Set<DFAState> set : mergedStateSets) {
            int minSize = set.stream().mapToInt(s -> dfa.outputOf(s).size()).min().getAsInt();
            long unionSize = set.stream().flatMap(s -> dfa.outputOf(s).stream()).distinct().count();
            if (unionSize <= (long)minSize) continue;
            return false;
        }
        return true;
    }

    private static class CombinedDFA {
        DFA dfa1;
        DFA dfa2;

        private CombinedDFA(DFA dfa1, DFA dfa2) {
            this.dfa1 = dfa1;
            this.dfa2 = dfa2;
        }

        private Set<DFAState> getStates() {
            return Stream.concat(this.dfa1.getAllStates().stream(), this.dfa2.getAllStates().stream()).collect(Collectors.toSet());
        }

        private Set<SparkField> outEdgesOf(DFAState s) {
            return s.outEdges();
        }

        private Set<Type> outputOf(DFAState s) {
            return s.getOutput();
        }
    }
}

