/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.mahjong;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import qilin.core.pag.AllocNode;
import qilin.core.pag.Node;
import qilin.pta.toolkits.common.FieldPointstoGraph;
import qilin.pta.toolkits.mahjong.automata.DFA;
import qilin.pta.toolkits.mahjong.automata.DFAEquivalenceChecker;
import qilin.pta.toolkits.mahjong.automata.DFAFactory;
import qilin.pta.toolkits.mahjong.automata.DFAState;
import qilin.util.UnionFindSet;

public class HeapAbstraction {
    private final FieldPointstoGraph fpg;
    private final DFAFactory dfaFactory;
    private final DFAEquivalenceChecker dfaEqChecker;
    private Map<AllocNode, Boolean> canMerged;

    public HeapAbstraction(FieldPointstoGraph fpg) {
        this.fpg = fpg;
        this.dfaFactory = new DFAFactory(fpg);
        this.dfaEqChecker = new DFAEquivalenceChecker();
    }

    public Map<AllocNode, AllocNode> computeMergedObjectMap() {
        UnionFindSet<AllocNode> uf = this.modelHeap();
        return HeapAbstraction.convertToMap(uf.getDisjointSets());
    }

    private UnionFindSet<AllocNode> modelHeap() {
        this.canMerged = new ConcurrentHashMap<AllocNode, Boolean>();
        Set<AllocNode> allObjs = this.fpg.getAllObjs();
        UnionFindSet<AllocNode> uf = new UnionFindSet<AllocNode>(allObjs);
        Map groupedObjs = allObjs.stream().collect(Collectors.groupingBy(Node::getType, Collectors.toSet()));
        groupedObjs.entrySet().parallelStream().forEach(entry -> {
            DFAMap dfaMap = new DFAMap();
            Set objs = ((Set)entry.getValue()).stream().filter(o -> this.canBeMerged((AllocNode)o, dfaMap)).collect(Collectors.toSet());
            for (AllocNode o1 : objs) {
                for (AllocNode o2 : objs) {
                    if (o1.getNumber() > o2.getNumber() || uf.isConnected(o1, o2) || !this.canBeMerged(o1, o2, dfaMap)) continue;
                    uf.union(o1, o2);
                }
            }
        });
        return uf;
    }

    private boolean canBeMerged(AllocNode o1, AllocNode o2, DFAMap dfaMap) {
        if (o1 == o2) {
            return true;
        }
        DFA dfa1 = dfaMap.retrieveDFA(o1);
        DFA dfa2 = dfaMap.retrieveDFA(o2);
        return this.dfaEqChecker.isEquivalent(dfa1, dfa2);
    }

    private boolean canBeMerged(AllocNode o, DFAMap dfaMap) {
        if (!this.canMerged.containsKey(o)) {
            boolean result = true;
            DFA dfa = dfaMap.retrieveDFA(o);
            for (DFAState s : dfa.getStates()) {
                if (dfa.outputOf(s).size() <= 1) continue;
                result = false;
                break;
            }
            this.canMerged.put(o, result);
        }
        return this.canMerged.get(o);
    }

    private static Map<AllocNode, AllocNode> convertToMap(Collection<Set<AllocNode>> objModel) {
        HashMap<AllocNode, AllocNode> map = new HashMap<AllocNode, AllocNode>();
        objModel.forEach(objs -> {
            AllocNode rep = HeapAbstraction.selectRepresentative(objs);
            objs.forEach(obj -> map.put((AllocNode)obj, rep));
        });
        return map;
    }

    private static AllocNode selectRepresentative(Set<AllocNode> objs) {
        return (AllocNode)objs.stream().findFirst().get();
    }

    private class DFAMap {
        private final Map<AllocNode, DFA> dfaMap = new HashMap<AllocNode, DFA>();

        private DFAMap() {
        }

        private DFA retrieveDFA(AllocNode o) {
            return this.dfaMap.computeIfAbsent(o, k -> HeapAbstraction.this.dfaFactory.getDFA(o));
        }
    }
}

