/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ArrayElement;
import qilin.core.pag.PAG;
import qilin.core.pag.SparkField;
import qilin.pta.toolkits.debloaterx.HeapContainerQuery;
import qilin.pta.toolkits.debloaterx.XUtility;
import qilin.util.Stopwatch;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.Type;

public class ContainerFinder {
    protected final PTA pta;
    protected final PAG pag;
    private final Set<AllocNode> notcontainers = ConcurrentHashMap.newKeySet();
    private final Map<AllocNode, Set<SparkField>> containers = new ConcurrentHashMap<AllocNode, Set<SparkField>>();
    private final XUtility utility;

    public ContainerFinder(PTA pta, XUtility utility) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.utility = utility;
    }

    public void run() {
        Stopwatch s1 = Stopwatch.newAndStart("pre-containerFinder");
        HashSet<AllocNode> remainObjs = new HashSet<AllocNode>();
        for (AllocNode heap2 : this.pag.getAllocNodes()) {
            Type type = heap2.getType();
            if (type instanceof ArrayType) {
                ArrayType at = (ArrayType)type;
                JNewArrayExpr nae = (JNewArrayExpr)heap2.getNewExpr();
                Immediate vl = nae.getSize();
                if (this.utility.isCoarseType((Type)at) && (!(vl instanceof IntConstant) || ((IntConstant)vl).getValue() != 0)) {
                    this.containers.computeIfAbsent(heap2, k -> new HashSet()).add(ArrayElement.v());
                    continue;
                }
                this.notcontainers.add(heap2);
                continue;
            }
            if (type instanceof ClassType) {
                ClassType refType = (ClassType)type;
                if (this.utility.isCoarseType((Type)refType) && heap2.getMethod() != null) {
                    remainObjs.add(heap2);
                    continue;
                }
                this.notcontainers.add(heap2);
                continue;
            }
            throw new RuntimeException("invalid type for " + heap2);
        }
        s1.stop();
        System.out.println(s1);
        Stopwatch s2 = Stopwatch.newAndStart("mid-containerFinder");
        remainObjs.parallelStream().forEach(this.utility::getHCQ);
        s2.stop();
        System.out.println(s2);
        Stopwatch s3 = Stopwatch.newAndStart("remain-containerFinder");
        remainObjs.parallelStream().forEach(heap -> {
            Set<SparkField> fields = this.utility.getFields((AllocNode)heap);
            fields = fields.stream().filter(f -> this.utility.isCoarseType(f.getType())).collect(Collectors.toSet());
            HeapContainerQuery hcq = this.utility.getHCQ((AllocNode)heap);
            for (SparkField field : fields) {
                boolean hasOut;
                boolean hasIn = this.hasNonThisStoreOnField((AllocNode)heap, field, hcq);
                if (!hasIn || !(hasOut = this.hasNonThisLoadFromField((AllocNode)heap, field, hcq))) continue;
                this.containers.computeIfAbsent((AllocNode)heap, k -> new HashSet()).add(field);
            }
            if (!this.containers.containsKey(heap)) {
                this.notcontainers.add((AllocNode)heap);
            }
        });
        s3.stop();
        System.out.println(s3);
        System.out.println("#ObjectsNotAContainer:" + this.notcontainers.size());
        System.out.println("#Container:" + this.containers.size());
    }

    private boolean hasNonThisStoreOnField(AllocNode heap, SparkField field, HeapContainerQuery hcq) {
        if (this.utility.hasNonThisStoreOnField(heap, field)) {
            return true;
        }
        return hcq.hasParamsStoredInto(field);
    }

    private boolean hasNonThisLoadFromField(AllocNode heap, SparkField field, HeapContainerQuery hcq) {
        if (this.utility.hasNonThisLoadFromField(heap, field)) {
            return true;
        }
        return hcq.hasOutMethodsWithRetOrParamValueFrom(field);
    }

    public boolean isAContainer(AllocNode heap) {
        if (this.containers.containsKey(heap)) {
            return true;
        }
        return ((MethodSignature)heap.getMethod().getSignature()).toString().startsWith("<java.util.Arrays: java.lang.Object[] copyOf(java.lang.Object[],int,java.lang.Class)>") || ((MethodSignature)heap.getMethod().getSignature()).toString().startsWith("<java.util.AbstractCollection: java.lang.Object[] toArray(java.lang.Object[])>");
    }
}

