/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.bean;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import qilin.core.context.ContextElements;
import qilin.core.pag.AllocNode;
import qilin.pta.toolkits.common.OAG;
import qilin.util.Pair;

public abstract class ContextSelector {
    protected int depth;
    protected Map<AllocNode, Set<ContextElements>> contextMap;
    protected Map<Pair<ContextElements, AllocNode>, Set<Pair<ContextElements, AllocNode>>> allocation = new HashMap<Pair<ContextElements, AllocNode>, Set<Pair<ContextElements, AllocNode>>>();

    protected ContextSelector(OAG oag) {
        this(oag, Integer.MAX_VALUE);
    }

    protected ContextSelector(OAG oag, int depth) {
        this.depth = depth;
        this.selectContext(oag);
    }

    public Set<ContextElements> contextsOf(AllocNode heap) {
        return this.contextMap.get(heap);
    }

    public Set<Pair<ContextElements, AllocNode>> allocatedBy(ContextElements ctx, AllocNode heap) {
        return this.allocation.get(new Pair<ContextElements, AllocNode>(ctx, heap));
    }

    protected abstract void selectContext(OAG var1);

    protected void addAllocation(ContextElements ctx, AllocNode heap, ContextElements newCtx, AllocNode succ) {
        Pair<ContextElements, AllocNode> csheap = new Pair<ContextElements, AllocNode>(ctx, heap);
        this.allocation.computeIfAbsent(csheap, k -> new HashSet());
        this.allocation.get(csheap).add(new Pair<ContextElements, AllocNode>(newCtx, succ));
    }
}

