/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.sets;

import java.util.Arrays;
import java.util.Iterator;
import qilin.core.sets.DoublePointsToSet;
import qilin.core.sets.P2SetVisitor;
import qilin.core.sets.PointsToSetInternal;
import qilin.util.BitSetIterator;
import qilin.util.BitVector;

public final class HybridPointsToSet
extends PointsToSetInternal {
    private static HybridPointsToSet emptySet = null;
    private final int[] nodeIdxs = new int[16];
    private BitVector bits = null;
    private int size = 0;
    private boolean empty = true;

    public static HybridPointsToSet getEmptySet() {
        if (emptySet == null) {
            emptySet = new HybridPointsToSet();
        }
        return emptySet;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void clear() {
        Arrays.fill(this.nodeIdxs, 0);
        this.bits = null;
        this.empty = true;
        this.size = 0;
    }

    private boolean nativeAddAll(HybridPointsToSet other, PointsToSetInternal exclude) {
        boolean ret = false;
        Iterator<Integer> it = other.iterator();
        while (it.hasNext()) {
            int idx = it.next();
            if (exclude != null && exclude.contains(idx)) continue;
            ret |= this.add(idx);
        }
        return ret;
    }

    @Override
    public boolean addAll(PointsToSetInternal other, PointsToSetInternal exclude) {
        if (other == null) {
            return false;
        }
        if (other instanceof DoublePointsToSet) {
            DoublePointsToSet dpts = (DoublePointsToSet)other;
            return this.nativeAddAll(dpts.getNewSet(), exclude) | this.nativeAddAll(dpts.getOldSet(), exclude);
        }
        return this.nativeAddAll((HybridPointsToSet)other, exclude);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new HybridPTSIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean forall(P2SetVisitor v) {
        if (this.bits == null) {
            for (int nodeIdx : this.nodeIdxs) {
                if (nodeIdx == 0) {
                    return v.getReturnValue();
                }
                v.visit(nodeIdx);
            }
        } else {
            BitSetIterator it = this.bits.iterator();
            while (it.hasNext()) {
                v.visit(it.next());
            }
        }
        return v.getReturnValue();
    }

    @Override
    public boolean contains(int idx) {
        if (this.bits == null) {
            for (int nodeIdx : this.nodeIdxs) {
                if (idx == nodeIdx) {
                    return true;
                }
                if (nodeIdx == 0) break;
            }
            return false;
        }
        return this.bits.get(idx);
    }

    @Override
    public boolean add(int idx) {
        boolean ret;
        if (this.bits == null) {
            for (int i = 0; i < this.nodeIdxs.length; ++i) {
                if (this.nodeIdxs[i] == 0) {
                    this.empty = false;
                    this.nodeIdxs[i] = idx;
                    ++this.size;
                    return true;
                }
                if (this.nodeIdxs[i] != idx) continue;
                return false;
            }
            this.bits = new BitVector();
            for (int nodeIdx : this.nodeIdxs) {
                if (nodeIdx == 0) continue;
                this.bits.set(nodeIdx);
            }
        }
        if (ret = this.bits.set(idx)) {
            ++this.size;
            this.empty = false;
        }
        return ret;
    }

    private class HybridPTSIterator
    implements Iterator<Integer> {
        private BitSetIterator it;
        private int idx;

        public HybridPTSIterator() {
            if (HybridPointsToSet.this.bits == null) {
                this.idx = 0;
            } else {
                this.it = HybridPointsToSet.this.bits.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (HybridPointsToSet.this.bits == null) {
                return this.idx < HybridPointsToSet.this.nodeIdxs.length && HybridPointsToSet.this.nodeIdxs[this.idx] != 0;
            }
            return this.it.hasNext();
        }

        @Override
        public Integer next() {
            if (HybridPointsToSet.this.bits == null) {
                return HybridPointsToSet.this.nodeIdxs[this.idx++];
            }
            return this.it.next();
        }
    }
}

